---
layout: post
title: How do I know if my site was hacked?
date: 2015-01-01
updated: 2022-03-04
description: >
  Steps to follow if you think that your site may be hacked.
tags:
  - security
---

Follow these steps if:

*   You've been alerted by Google that your site is hacked
*   You see a warning in search that your site is hacked or compromised
*   You're not sure if your site is actually hacked

If you're unsure if your site is actually hacked, or if you think your site
was incorrectly flagged, start by registering your site in
[Search Console](http://search.google.com/search-console/). Go to the
[Security Issues](https://search.google.com/search-console/security-issues)
sections of Search Console and look for example URLs where Google detected
that your site has been hacked. The video below provides an overview of how Search Console can help you.

{% YouTube "oPsOZI8x5VM" %}

If you're unable to see hacked content on the URLs provided in Search Console,
the hacked content might be using a technique known as
[cloaking](//support.google.com/webmasters/answer/66355). Cloaking makes
cleaning a site more difficult by showing different content to different
types of users. For example, when you go to a page on your site like
www.example.com/cheap-drugs, you might see a page without any content.
This might lead you to believe that the hacked content on your site
doesn't exist. However, when a search engine like Google accesses
www.example.com/cheap-drugs, it will see spammy words and links.

To check for cloaking, use the
[Hacked Sites Troubleshooter](https://support.google.com/webmasters/troubleshooter/6155978).
The troubleshooter will walk you through a few tools like the `site:`
search operator and
[Inspect URL tool](https://support.google.com/webmasters/answer/9012289)
that can help you uncover any cloaked hacked content.

After you've double checked your pages, if you still think think your site
was incorrectly flagged, please post in the
[Webmaster Help Forums](https://productforums.google.com/forum/#!forum/webmasters).
Otherwise, start building your [support team](/build-a-support-team/).

