---
layout: post
title: FAQ for hacked sites
date: 2015-01-01
updated: 2022-03-04
description: >
  This article brings together answers to the questions about hacking we at Google hear most often. 
tags:
  - security
---

This article brings together answers to the questions about hacking we at
Google hear most often.

## Why did my site get hacked? {: #mean }

Hackers have different motives for compromising a website. Examples include:

* **Financial gain through web spam:** Placing spam links on your website or
  redirecting your website's traffic to external parties.
* **Stealing sensitive information:** Copying files containing customer
  data like credit card numbers, personally identifiable information, or
  login credentials.
* **Communicating a political or social message:** Defacing a website as a
  form of hacktivism to emphasize a point of view and cause change.
* **Malware:** Injecting malicious code through scripts or iFrames that pull
  content from another website that tries to attack any computer that views
  the page.
* **Thrill-seeking or vandalism:** For no particular reason other than the
  thrill of invading and vandalizing your site.

## How do I know I’ve been hacked? {: #know }

Examples of common signs that your website has been attacked include
unusual traffic spikes (especially from unrelated search terms), visitors
reporting malware, newly created account(s) with administrator privileges,
or suspicious new pages added to your site.

## How did I get hacked? {: #how }

There are many possibilities such as software vulnerabilities, leaked or
guessed password, unauthenticated administrator pages, unsanitized database
queries, unnecessary open ports, or exploiting a human weaknesses through
social engineering like phishing or impersonation of a trusted authority.
Eliminating or mitigating these vulnerabilities is extremely important.

## Where can I go if I have additional questions? {: #questions }

The [Webmaster Help Forums](https://support.google.com/webmasters/go/community)
has an active group of Googlers and technical contributors that can help you
with additional feedback. Also, most major Content Management System (CMS)
providers have detailed documentation on how to resolve hacked cases. You
can also seek help from a trusted security professional.

## How can I reproduce the warnings displayed to the users of my site?

Safe Browsing displays warnings based on the user's browsing context. As a webmaster,
you may not be able to easily reproduce the warnings in your own browsing.
The Search Console [Security
Issues report](https://support.google.com/webmasters/answer/9044101) will tell
you whether the issues Safe Browsing has seen with your website have been
addressed.

