---
layout: post
title: Assess spam damage
date: 2015-01-01
updated: 2022-03-04
description: >
  Find out what to do if your site has been hacked to host spam.
tags:
  - security
---

This step is for sites hacked to host spam, often with the warning
_"This site may be hacked"_ displayed in search results. It's one of the
longest steps in the recovery process. In this step, you'll compile a list of
the damaged files on your site. You'll use this list in a later step,
[Clean and maintain your site](/clean-and-maintain-your-site/).

{% Aside %}
If your site was affected by malware and is flagged with the warning
_"This site may harm your computer"_ in search results, see the
corresponding article,
[Assess malware damage (Hacked with malware)](/secure/hacked-with-malware/).
{% endAside %}

{% YouTube "lG5lOix9b9k" %}

Because certain hacking campaigns affect hundreds and thousands of sites in
similar ways, they can be cleaned up using a set of specific steps. If any of
these hacking campaigns describe the hack on your site, click through to read
the guide.

* [Fixing the Japanese Keyword Hack](/secure/fixing-the-japanese-keyword-hack/)
* [Fixing the Gibberish Hack](/secure/fixing-the-gibberish-hack/)
* [Fixing the Cloaked Keywords and Links Hack](/secure/fixing-the-cloaked-keywords-hack/)
