---
layout: post
title: Web Payments overview
subhead: |
  Learn more about Web Payments and how they work.
authors:
  - agektmr
date: 2018-09-10
updated: 2021-09-14
description: |
  Learn more about Web Payments and how they work.
tags:
  - payments
feedback:
  - api
---


Web Payments is an emerging web standard being developed by the W3C to
simplify online payments and enable a broader set of players to participate
easily in the payments ecosystem on the web. The standards are flexible; they
work with various types of payment systems and are intended to work on any
browser on any device, payment method, or payment service provider. This
flexibility enables development simplicity, deployment consistency, and future
compatibility with emerging payment technologies.

## Benefits of Web Payments

**For consumers**, they simplify checkout flow, by making it a few taps instead
of typing small characters many times on a virtual keyboard.

**For merchants**, they make it easier to implement with a variety of payment
options already filtered for the customer.

**For payment handlers**, they allow bringing any type of payment methods to the
web with relatively easy integration.

**For payment service providers**, they bring new payment methods and enhance
the ability of businesses to serve more customers with a better developer
experience and more secure solutions.

## Three principles of Web Payments

<section style="display:flex;background-color:#f7f7f7;padding-bottom:32px;">
  <div style="min-width:50%;padding-top:32px;">
    {% Img src="image/YLflGBAPWecgtKJLqCJHSzHqe2J2/voaNzDaJcKQFBwtuFem7.png", alt="Standard and Open", width="800", height="508" %}
  </div>
  <div style="min-width:50%">
    <h3>Standard and open</h3>
    Web Payments are an open payment standard for the web platform for the first time
    in history. They are available for anyone to implement.</div>
</section>
<section style="display:flex;padding-bottom:32px;">
  <div style="min-width:50%">
    <h3>Easy and consistent</h3>
    Web Payments make checkout easy for the user, by reusing stored
payments and address information and removing the need for the user to fill in checkout forms.
Since the UI is implemented by the browser natively, users see a familiar and consistent checkout
experience on any website that uses the standard.</div>
  <div style="min-width:50%;padding-top:32px;">
    {% Img src="image/YLflGBAPWecgtKJLqCJHSzHqe2J2/DXwSsz8wgEO3ffCT2s15.png", alt="Easy and Consistent", width="800", height="508" %}
  </div>
</section>
<section style="display:flex;background-color:#f7f7f7;padding-bottom:32px;">
  <div style="min-width:50%;padding-top:32px;">
    {% Img src="image/YLflGBAPWecgtKJLqCJHSzHqe2J2/9ksUqSzpIvHLiazAoyTk.png", alt="Secure and Flexible", width="800", height="508" %}
  </div>
  <div style="min-width:50%">
    <h3>Secure and flexible</h3>
    Web Payments provide industry-leading payment technology to the
web, and can easily integrate a secure payment solution.</div>
</section>

## Next up

Learn [How payment ecosystem works](/how-payment-ecosystem-works) with Web
Payments.


