---
layout: post
title: Mini app DevTools
authors:
  - thomassteiner
date: 2021-03-03
# updated: 2021-03-03
description: |
  This chapter provides details on the DevTools experience of various mini apps platforms.
tags:
  - mini-apps
---

{% Aside %}
  This post is part of an article collection where each article builds upon previous articles.
  If you just landed here, you may want to start reading from the [beginning](/mini-app-super-apps/).
{% endAside %}

## The developer experience

Now that I have covered mini apps _per se_, I want to focus on the developer experience for the
various super app platforms. Mini app development on all platforms happens in IDEs that are provided
for free by the super app platforms. While there are more, I want to focus on the four most popular
ones, and a fifth for Quick App for comparison.

## Mini app IDEs

Like the super apps, the majority of the IDEs are available only in Chinese. You actually want to
make sure that you install the Chinese version and not a sometimes available English (or overseas)
version, since it might not be up-to-date. If you are a macOS developer, be aware that not all IDEs
are signed, which means macOS refuses to run the installer. You can, **at your own risk**, bypass
this as
[outlined by Apple help](https://support.apple.com/guide/mac-help/open-a-mac-app-from-an-unidentified-developer-mh40616/mac).

- [WeChat DevTools](https://developers.weixin.qq.com/miniprogram/dev/devtools/download.html)
- [Alipay DevTools](https://render.alipay.com/p/f/fd-jwq8nu2a/pages/home/index.html)
- [Baidu DevTools](https://smartprogram.baidu.com/docs/develop/devtools/history/)
- [ByteDance DevTools](https://microapp.bytedance.com/docs/zh-CN/mini-app/develop/developer-instrument/developer-instrument-update-and-download)
- [Quick App DevTools](https://www.quickapp.cn/docCenter/IDEPublicity)

## Mini app starter projects

To get started quickly with mini app development, all super app providers offer demo apps
that can be downloaded and tested immediately, and that are sometimes also integrated in the "New
Project" wizards of the various IDEs.

- [WeChat demo](https://github.com/wechat-miniprogram/miniprogram-demo)
- [Alipay demo](https://opendocs.alipay.com/mini/introduce/demo)
- [Baidu demo](https://smartprogram.baidu.com/docs/develop/tutorial/demo/)
- [ByteDance demo](https://microapp.bytedance.com/docs/zh-CN/mini-app/introduction/plug-in/example)
- [Quick App demo](https://github.com/quickappcn/sample)

## Development flow

After launching the IDE and loading or creating a (demo) mini app, the first step is always to log
in. Usually you just need to scan a QR code with the super app (where you are already logged in)
that is generated by the IDE. Very rarely do you have to enter a password. Once you are logged in,
the IDE knows your identity and lets you start programming, debugging, testing, and submitting your
app for review. In the following, you can see screenshots of the five IDEs mentioned in the
paragraph above.

<figure>
  {% Img src="image/tcFciHGuF3MxnTr1y5ue01OGLBn2/YvjvlB82SfPqHBl56Rz4.png", alt="WeChat DevTools application window showing simulator, code editor, and debugger.", width="800", height="463" %}
  <figcaption>
    WeChat DevTools with simulator, code editor, and debugger.
  </figcaption>
</figure>

<figure>
  {% Img src="image/tcFciHGuF3MxnTr1y5ue01OGLBn2/iLbYZFZ9ec245segsIKk.png", alt="Alipay DevTools application window showing code editor, simulator, and debugger.", width="800", height="454" %}
  <figcaption>
    Alipay DevTools with code editor, simulator, and debugger.
  </figcaption>
</figure>

<figure>
  {% Img src="image/tcFciHGuF3MxnTr1y5ue01OGLBn2/svoq0p6GO1PCT0k0bdba.png", alt="Baidu DevTools application window showing simulator, code editor, and debugger.", width="800", height="540" %}
  <figcaption>
    Baidu DevTools with simulator, code editor, and debugger.
  </figcaption>
</figure>

<figure>
  {% Img src="image/tcFciHGuF3MxnTr1y5ue01OGLBn2/myapOcgYOwsEumeFbL3A.png", alt="ByteDance DevTools application window showing simulator, code editor, and debugger.", width="800", height="561" %}
  <figcaption>
    ByteDance DevTools with simulator, code editor, and debugger.
  </figcaption>
</figure>

<figure>
  {% Img src="image/tcFciHGuF3MxnTr1y5ue01OGLBn2/dUsfozY82E2YhtlxNJz9.png", alt="Quick App DevTools application window showing code editor, simulator, and debugger.", width="800", height="485" %}
  <figcaption>
    Quick App DevTools with code editor, simulator, and debugger.
  </figcaption>
</figure>

As you can see, the fundamental components of all IDEs are very similar. You always have a code
editor based on the [Monaco Editor](https://microsoft.github.io/monaco-editor/), the same project
that also powers [VS Code](https://github.com/Microsoft/vscode). In all IDEs, there is a debugger
based on the [Chrome DevTools frontend](https://github.com/ChromeDevTools/devtools-frontend) with
some modifications, more on those later (see [Debugger](/mini-app-devtools/#debugger)). The IDEs _per se_ are
implemented either as [NW.js](https://nwjs.io/) or as [Electron](https://www.electronjs.org/) apps,
the simulators in the IDEs are realized as an
[NW.js `<webview>` tag](https://docs.nwjs.io/en/latest/References/webview%20Tag/) or
[Electron `<webview>` tag](https://www.electronjs.org/docs/api/webview-tag), which in turn are based on
a [Chromium `<webview>` tag](https://www.electronjs.org/docs/api/webview-tag). If you are interested in
the IDE internals, you can oftentimes simply inspect them with Chrome DevTools with the keyboard
shortcut <kbd>Control</kbd>+<kbd>Alt</kbd>+<kbd>I</kbd> (or
<kbd>Command</kbd>+<kbd>Option</kbd>+<kbd>I</kbd> on Mac).

<figure>
  {% Img src="image/tcFciHGuF3MxnTr1y5ue01OGLBn2/yXcGmOhbi3xrcMIDhw1t.png", alt="Chrome DevTools used to inspect Baidu's DevTools showing the simulator's webview tag in the Chrome DevTools' Elements panel.", width="800", height="504" %}
  <figcaption>
    Inspecting Baidu DevTools with Chrome DevTools reveals that the simulator is realized as an Electron <code>&lt;webview&gt;</code> tag.
  </figcaption>
</figure>

## Simulator and real device testing and debugging

The simulator is comparable with what you might know from Chrome DevTools'
[device mode](https://developer.chrome.com/docs/devtools/device-mode/). You can simulate
different Android and iOS devices, change the scale and device orientation, but also simulate
various network states, memory pressure, a barcode reading event, unexpected termination, and dark
mode.

While the built-in simulator suffices to get a rough feeling for how the app behaves, on-device
testing, like with regular web apps, is irreplaceable. Testing an in-development mini app is just a
QR code scan away. For example, in ByteDance DevTools, scanning a QR code dynamically generated by the IDE
with a real device leads to a cloud-hosted version of the mini app that can then immediately be
tested on the device. The way this works for ByteDance is that the URL behind the QR code
([example](https://t.zijieimg.com/JMvE5kM/?a=b)) redirects to a hosted page
([example](https://s.pstatp.com/toutiao/resource/tma_c_reveal_fe/static/redirect.html?version=v2&app_id=ttb3d2c56f2ce8e78c&scene=0&version_type=preview&token=3605997583095982&start_page=pages%2Fcomponent%2Findex&url=%7B%22id%22%3A%22ttb3d2c56f2ce8e78c%22%2C%22name%22%3A%22%E5%90%8D%E7%A7%B0%E9%87%8D%E7%BD%AEttb3d2c56f2ce8e78c%22%2C%22icon%22%3A%22%22%2C%22url%22%3A%22https%3A%2F%2Fsf1-ttcdn-tos.pstatp.com%2Fobj%2Fdeveloper%2Fapp%2Fttb3d2c56f2ce8e78c%2Fpreview%2F%22%2C%22orientation%22%3A0%2C%22ttid%22%3A%226857810517176942605%22%2C%22state%22%3A1%2C%22type%22%3A1%2C%22tech_type%22%3A1%2C%22version%22%3A%22undefined%22%7D&tech_type=1&bdpsum=281c864)),
that contains links with special URI schemes like, for example, `snssdk1128://`, to preview the mini
app on the various ByteDance super apps like Douyin or Toutiao
(here is an [example](snssdk1128://microapp?version=v2&app_id=ttb3d2c56f2ce8e78c&scene=0&version_type=preview&token=3605997583095982&start_page=pages%2Fcomponent%2Findex&url=%7B%22id%22%3A%22ttb3d2c56f2ce8e78c%22%2C%22name%22%3A%22%E5%90%8D%E7%A7%B0%E9%87%8D%E7%BD%AEttb3d2c56f2ce8e78c%22%2C%22icon%22%3A%22%22%2C%22url%22%3A%22https%3A%2F%2Fsf1-ttcdn-tos.pstatp.com%2Fobj%2Fdeveloper%2Fapp%2Fttb3d2c56f2ce8e78c%2Fpreview%2F%22%2C%22orientation%22%3A0%2C%22ttid%22%3A%226857810517176942605%22%2C%22state%22%3A1%2C%22type%22%3A1%2C%22tech_type%22%3A1%2C%22version%22%3A%22undefined%22%7D&tech_type=1&bdpsum=281c864)).
Other super app providers do not go through an intermediate page, but open the preview directly.

<figure>
  {% Img src="image/tcFciHGuF3MxnTr1y5ue01OGLBn2/p0CrYvh00oAV9AUzeoU6.png", alt="ByteDance DevTools showing a QR code that the user can scan with the Douyin app to see the current mini app on their device.", width="800", height="551" %}
  <figcaption>
    ByteDance DevTools showing a QR code that the user can scan with the Douyin app for immediate on-device testing.
  </figcaption>
</figure>

<figure>
  {% Img src="image/tcFciHGuF3MxnTr1y5ue01OGLBn2/LNOqaa8z2Oo4CZPa48Bw.png", alt="Intermediate landing page for previewing a ByteDance mini app in various of the company's super apps, opened on a regular desktop browser for reverse-engineering the process.", width="800", height="433" %}
  <figcaption>
     Intermediate ByteDance landing page for previewing a mini app (opened on a desktop browser to show the flow).
  </figcaption>
</figure>

An even more compelling feature is cloud-based preview remote debugging. After simply scanning a
special likewise IDE-generated QR code, the mini app opens on the physical device, with a Chrome
DevTools window running on the computer for remote debugging.

<figure>
  {% Img src="image/tcFciHGuF3MxnTr1y5ue01OGLBn2/N5Crv3ryZ3bCNFMv7Lir.png", alt="A mobile phone running a mini app with parts of the UI highlighted by the ByteDance DevTools debugger running on a laptop inspecting it.", width="800", height="600" %}
  <figcaption>
   Wirelessly remote-debugging a mini app on a real device with ByteDance DevTools.
  </figcaption>
</figure>

## Debugger

### Elements debugging

The mini app debugging experience is very familiar to anyone who has ever worked with Chrome
DevTools. There are some important differences, though, that make the workflow tailored to mini
apps. Instead of the Chrome DevTools'
[Elements panel](https://developer.chrome.com/docs/devtools/#elements), mini app IDEs
have a customized panel that is tailored to their particular dialect of HTML. For example, in the
case of WeChat, the panel is called
[Wxml](https://developers.weixin.qq.com/miniprogram/en/dev/framework/view/wxml/), which stands for
WeiXin Markup Language. In Baidu DevTools, it's called
[Swan Element](https://smartprogram.baidu.com/docs/develop/framework/dev/). ByteDance DevTools calls
it
[Bxml](https://microapp.bytedance.com/docs/zh-CN/mini-app/develop/guide/mini-app-framework/view/ttml).
Alipay names it [AXML](https://opendocs.alipay.com/mini/framework/axml), and Quick App references
the panel simply as [UX](https://doc.quickapp.cn/tutorial/framework/for.html). I will dive into
these markup languages [later](/mini-app-markup-styling-and-scripting/#markup-languages).

<figure>
  {% Img src="image/tcFciHGuF3MxnTr1y5ue01OGLBn2/k1FO68wZhzpRNvQl2bN3.png", alt="Inspecting an image with WeChat DevTools' 'Wxml' panel. It shows that the tag in use is an `image` tag.", width="800", height="572" %}
  <figcaption>
    Inspecting an <code>&lt;image&gt;</code> element with WeChat DevTools.
  </figcaption>
</figure>

### Custom elements under the hood

Inspecting the WebView on a real device via [about://inspect/#devices](about://inspect/#devices)
reveals that WeChat DevTools was deliberately hiding the truth. Where WeChat DevTools showed an
`<image>`, the actual thing I am looking at is a custom element called `<wx-image>` with a `<div>`
as its only child. It is interesting to note that this custom element does not use
[Shadow DOM](https://developer.mozilla.org/docs/Web/Web_Components/Using_shadow_DOM). More on
these components [later](/mini-app-components/).

<figure>
  {% Img src="image/tcFciHGuF3MxnTr1y5ue01OGLBn2/on9Ty46RyteTI6QTc2vk.png", alt="Inspecting a WeChat mini app running on a real device with Chrome DevTools. Where WeChat DevTools reported I am looking at an `image` tag, Chrome DevTools reveals I am actually dealing with a `wx-image` custom element.", width="800", height="385" %}
  <figcaption>
    Inspecting an <code>&lt;image&gt;</code> element with WeChat DevTools reveals that it is actually a <code>&lt;wx-image&gt;</code> custom element.
  </figcaption>
</figure>

### CSS debugging

Another difference is the new length unit `rpx` for responsive pixel in the various dialects of CSS
(more on this unit [later](/mini-app-markup-styling-and-scripting/#styling)). WeChat DevTools uses device-independent CSS length units to
make developing for different device sizes more intuitive.

<figure>
  {% Img src="image/tcFciHGuF3MxnTr1y5ue01OGLBn2/bf4YBcscBzbmQtJig7Ij.png", alt="Inspecting a view with a specified top and bottom padding of `200rpx` in WeChat DevTools.", width="800", height="486" %}
  <figcaption>
    Inspecting the padding specified in responsive pixels (<code>200rpx 0</code>) of a view with WeChat DevTools.
  </figcaption>
</figure>

## Performance auditing

Performance is front and center for mini apps, so it is no surprise that WeChat DevTools and some
other DevTools have an integrated Lighthouse-inspired auditing tool. The focus areas of the audits
are Total, Performance, Experience, and Best Practice. The view of the IDE can be customized. In the
screenshot below I have temporarily hidden the code editor to have more screen real estate for the
audit tool.

<figure>
  {% Img src="image/tcFciHGuF3MxnTr1y5ue01OGLBn2/q8Rze6pR9mpDXw9VCaEs.png", alt="Running a performance audit with the built-in audit tool. The scores show Total, Performance, Experience, and Best Practice, each 100 out of 100 points.", width="800", height="485" %}
  <figcaption>
    The built-in Audit tool in WeChat DevTools showing Total, Performance, Experience, and Best Practice.
  </figcaption>
</figure>

## API mocking

Rather than requiring the developer to set up a separate service, mocking API responses is directly
part of WeChat DevTools. Via an easy-to-use interface the developer can set up API endpoints and the
desired mock responses.

<figure>
  {% Img src="image/tcFciHGuF3MxnTr1y5ue01OGLBn2/olJmRvdl0zkoWZiiOkiP.png", alt="Setting up a mock response for an API endpoint in WeChat DevTools.", width="800", height="485" %}
  <figcaption>
    WeChat DevTools' integrated API response mocking feature.
  </figcaption>
</figure>

{% Aside 'success' %}
  Read on to learn about the [mark-up, styling, and scripting of mini apps](/mini-app-markup-styling-and-scripting/).
{% endAside %}

## Acknowledgements

This article was reviewed by
[Joe Medley](https://github.com/jpmedley),
[Kayce Basques](https://github.com/kaycebasques),
[Milica Mihajlija](https://github.com/mihajlija),
[Alan Kent](https://github.com/alankent),
and Keith Gu.
