---
title: Learn PWA
authors:
  - firt
description: A course that breaks down every aspect of modern progressive web app development.
date: 2021-11-03
updated: 2022-05-16
---

## Welcome to Learn Progressive Web Apps!

Welcome to Learn Progressive Web Apps!

This course covers the fundamentals of Progressive Web App development in easy-to-understand pieces.
Over the following modules, you'll learn what a Progressive Web App is,
how to create one or upgrade your existing web content,
and how to add all the pieces for an offline, installable app.
Use the menu pane to navigate the modules. (The menu is at left on desktop or behind the hamburger menu on mobile.)

You'll learn PWA fundamentals like the Web App Manifest,
service workers, how to design with an app in mind,
how to use other tools to test and debug your PWA.
After these fundamentals, you'll learn about integration with the platform and operating system,
how to enhance your PWA's installation and usage experience, and how to offer an offline experience.

Each module includes interactive demos and self-assessments for you to test your knowledge.
You will be able to test and try demos on your mobile phone, tablet,
or laptop while playing with code to understand the fundamentals of what makes a Progressive Web App.

This course is created for a beginner and advanced web developers alike.
You can go through the series from start to finish to get a general understanding of PWA from top to bottom,
or you can use it as a reference for specific subjects.
For those new to web development you will need a grounding in HTML, CSS, and JavaScript to follow along.
Check out [Learn CSS](/learn/css), and the
[HTML](https://developer.mozilla.org/docs/Learn/HTML) and
[JavaScript](https://developer.mozilla.org/docs/Learn/JavaScript) courses on MDN.

Here's what you'll learn:

{% include 'partials/course-index.njk' %}

So, are you ready to learn PWA?

{% Aside %}
This course was written by [Maximiliano Firtman](https://twitter.com/firt), with input and review from [Rachel Andrew](https://twitter.com/rachelandrew), [Adriana Jara](https://twitter.com/tropicadri), [Pete LePage](https://twitter.com/petele), [Sam Richard](https://twitter.com/snugug), and [Joe Medley](https://twitter.com/medleyjp).
{% endAside %}
