---
title: Learn HTML
authors:
  - estelleweyl
description: This HTML course for web developers provides a solid overview for developers, from novice to expert level HTML.
date: 2022-09-08
tags:
  - html
---

## Welcome to Learn HTML!

Welcome to HTML!  HyperText Markup Language, or HTML, is the backbone of the web, providing the content, as well as the structure of that content, that you see displayed in your web browser.

Unless you're reading a PDF or a printed version of this page, this content is made up of various HTML elements and text. HTML is the content layer of the web. HTML elements are the nodes that make up the [Document Object Model](https://developer.mozilla.org/docs/Web/API/Document_Object_Model).

[Cascading Style Sheets](/learn/css/) provide the look and feel, or presentation layer of the page. [JavaScript](https://developer.mozilla.org/docs/Learn/JavaScript) is the behavior layer, often used to manipulate the objects within a document. Sites that are built with JavaScript frameworks are really just manipulating HTML. In turn, it's important to mark up your HTML in a way that scripts can easily parse and that assistive technologies can easily understand. This means writing HTML code with modern standards.

# Overview

This HTML course for web developers provides a solid overview for developers, from novice to expert level HTML. If you're completely new to HTML, you will learn how to build structurally sound content. If you've been building websites for years, this course may fill in gaps in knowledge that you didn't even know you had.

Along this journey, we will be building the structure for [MachineLearningWorkshop.com](https://machinelearningworkshop.com). No machines were harmed in the creation of this series.

**This is not a complete reference**. Each section introduces the section topic with brief explanations and examples, providing you an opportunity to explore further. There will be links to topic references, such as [MDN](https://developer.mozilla.org) and [WHATWG](https://html.spec.whatwg.org/multipage/) specifications, and other [web.dev](/learn) articles. While this is not an accessibility course, each section will include accessibility best practices and specific issues, with links to deeper dives on the topic. Each section will have a short assessment to help people confirm their understanding.

Here's what you'll learn:

{% include 'partials/course-index.njk' %}

So, are you ready to learn HTML? [Let's get started](/learn/html/overview/).

{% Aside %}
This course was written by [Estelle Weyl](https://front-end.social/@estelle), with input and review from [Rachel Andrew](https://twitter.com/rachelandrew), and [Jhey Tompkins](https://twitter.com/jh3yy).
{% endAside %}
