---
title: How to test forms for usability
description: >
  Discover how to do usability testing and ensure your form works well for all your users.
authors:
  - michaelscharnagl
date: 2021-11-03
---

## What is usability testing?

Usability testing is a technique to evaluate a device or product, such as a web form. 
By testing your form on real users, you can identify issues that automated tools may not find. 
You learn first-hand where you need to improve your form.

To conduct a usability test, 
you give a person a task such as asking them to complete a form, 
watch them doing the task, then ask them to 'think aloud'. 
During the test, you take notes about their interactions. 
After the test, you ask questions. This way, you find out where your form needs improvements.  

## Test your forms with real people

First, you need to find people who can test your form. 
Ask family members, friends, and colleagues to test your form. 

{% Aside %}
Testing doesn't have to be difficult. To improve your forms you don't need a usability lab and 
complex reporting methodologies!

Testing with one single other person is likely to help you improve your forms. 
Testing with two or more is even better. Take simple notes and make changes accordingly.
{% endAside %}

Try to get as diverse a range of testers as possible: 
in particular, think about age, and technical experience. 

Users may be situationally, temporarily, or permanently impaired. 
For example, a user could have a vision impairment that makes it difficult for them to read text without sufficient contrast, 
or a user may have a temporary arm injury that requires them to fill out the form with one hand. 

Testing with a diverse range of people helps you find usability issues you may not be aware of. 
Learn more about [inclusive design](https://www.microsoft.com/design/inclusive/), 
the linked site provides personas and sample activities to help you with inclusive UX testing.

For a high-traffic site, 
you should work with an accessibility consulting company 
that can provide comprehensive testing with assistive technologies and expert advice on fixing any issues found.

## Identify issues

You found people to test your form. How does a usability test work in practice? 

Ask people to complete specific tasks. 
Say you want to test your form. 
Ask them to fill out your form. 
Are they able to locate the form from the homepage? 
Are they able to successfully submit the form? 
Ask them about their experience. 
As they fill out the form, ask them to explain what they're doing and any issues they encounter.

## Ensure your form is accessible

How can you make sure your form is accessible to all your users?

The best way to ensure your form works as expected is by testing it with real people. 
Ask a friend or colleague to complete your form. 
You may be surprised how differently other people use your form, 
and what is important for them.

Finding people with different needs, who can test your form, 
isn't always possible. 
You should, however, always do an accessibility review of your own. 
For example, you can 
[emulate vision deficiencies](https://developer.chrome.com/blog/new-in-devtools-83/#vision-deficiencies), 
use a screen reader on your phone or computer, 
or use only your keyboard to fill out your form. 
Try navigating your form via a screen reader such as 
[VoiceOver on Mac](https://www.youtube.com/watch?v=5R-6WvAihms&list=PLNYkxOF6rcICWx0C9LVWWVqvHlYJyqw7g&index=6) or 
[NVDA](https://www.nvaccess.org/) on Windows.

Learn more about 
[doing an accessibility review](/how-to-review/).

## Measure and monitor impact of changes

After testing with real people and gathering feedback, 
it's time to adapt your form to the needs of your users. 
How can you be sure the new version is better than the previous one? 

You can ask the same people who tested your form before, to test your form again. 
Give them the same tasks, and ask the same questions afterwards. 
Was it easier to use this time? Did they encounter any new issues?

You tested your forms at home or in the office. 
How can you test and monitor the experience of your end users? 
Use analytics, and [real user measurement (RUM)](/user-centric-performance-metrics/). 
Implement [goal funnels](https://support.google.com/analytics/answer/6180923?hl=en) 
in analytics to check if changes reduce form abandonment and the time it takes for users to complete your form.

## Test different form designs with end users

One way to get results quicker is by doing A/B testing. You create two versions of your form, and randomly provide one version or the other to your users: some people get version A, and some get version B. Comparing results for the two versions helps you decide which version to use for later iterations. 

Learn more about [A/B testing](https://www.smashingmagazine.com/2010/06/the-ultimate-guide-to-a-b-testing/).

## Resources

- [Discount Usability Testing](https://www.nngroup.com/articles/discount-usability-20-years/)
- [Hallway Usability Testing](https://digital.gov/2014/02/19/10-tips-for-better-hallway-usability-testing/)
- [Doing an accessibility review](/how-to-review/)
