---
title: Learn Forms
authors:
  - michaelscharnagl
description: A course about HTML forms to help you improve your web developer expertise.
date: 2021-11-03
---

## Welcome to Learn forms 

This course breaks down HTML forms into easy to understand pieces. 
Over the next few modules, you'll learn how an HTML form works and how to use them effectively in your projects. 
Use the menu pane by the **Learn Forms** logo to navigate the modules.

You'll learn how to build a basic HTML form, about HTML form elements, 
styling forms, help users re-entering data, 
ensuring the form is accessible, and secure, how to test your forms, and about specific form types. 

Each module is full of interactive demos and self-assessments for you to test your knowledge.

This course is suitable for beginners and advanced HTML developers. 
The first few modules help you get started with building HTML forms, 
the other modules give more detail. 
You can go through the series from start to finish to get a general understanding of HTML forms, 
or pick a specific module you want to learn more about. 

## Prerequisites

Before starting this course, you should know about HTML. 
For those new to web development, 
check out the [intro to HTML](https://developer.mozilla.org/docs/Learn/HTML/Introduction_to_HTML) 
course from MDN to learn all about how to write markup.

## Demos

For most demos, we use [CodePen](https://codepen.io/).

Looking at the demos, you might wonder where the styles come from. 
We use a general stylesheet included in all demos, so only the relevant styles are shown there. 
In CodePen, you can select included CSS files from Settings.

## Form controls and form fields

A **form control** is an element that enables user interaction and data entry or selection: 
an `<input>`, `<select>`, `<textarea>` or `<button>`.

Sometimes **form field** is used to refer to form controls, 
in particular elements for text entry: `<input>` and `<textarea>`.

## Here's what you'll learn

{% include 'partials/course-index.njk' %}

So, are you ready to learn about forms? [Let's get started](/learn/forms/form-element/).

{% Aside %}  
This course is written and edited by forms community experts: 
[Michael Scharnagl](https://twitter.com/justmarkup), 
[Sam Dutton](https://twitter.com/sw12), 
and [Rachel Andrew](https://twitter.com/rachelandrew). <a href="https://twitter.com/rob_dodson">Rob Dodson</a> and <a href="https://twitter.com/jiwoong">Jiwoong Lee</a> shepherded the UX and production build, along with help from <a href="https://twitter.com/devnook">Ewa Gasperowicz</a> and <a href="https://twitter.com/samthor">Sam Thorogood</a>. 
{% endAside %}
