---
title: Conclusion and next steps
description: >
 Further resources to help you take your next steps.
authors:
  - michaelscharnagl
  - samdutton
  - rachelandrew
  - robdodson
  - jiwoong
date: 2021-11-03
---

Congratulations! You've made it to the end.
So far, you've learned a lot about forms,
and hopefully you feel more comfortable now building your own forms.

What's next? One of the best ways to learn is to try out what you've learned:
implement an HTML form of your own.
To continue to build your HTML forms knowledge, here are some additional resources to explore:

## Additional resources

- [HTML forms guide on MDN](https://developer.mozilla.org/docs/Learn/Forms)
- [Learn CSS](/learn/css)
- [WebAIM: Creating Accessible Forms](https://webaim.org/techniques/forms)
- [Payment and address forms best practices](/payment-and-address-form-best-practices)
- [Sign-up form best practices](/sign-up-form-best-practices)
- [Sign-in form best practices](/sign-in-form-best-practices)
- [Best Practices For Mobile Form Design](https://www.smashingmagazine.com/2018/08/best-practices-for-mobile-form-design/)
- [OWASP Cheat Sheet series](https://owasp.org/www-project-cheat-sheets/): best practices for privacy and security.
- [NIST Identity Guidelines](https://pages.nist.gov/800-63-3/sp800-63-3.html): US National Institute of Standards and Technology guidelines for passwords and other identity topics.
- [12 best practices for user account, authorization and password management](https://cloud.google.com/blog/products/gcp/12-best-practices-for-user-account): outlines core back-end principles for managing user accounts.
- [Passwords Evolved: Authentication Guidance for the Modern Era](https://www.troyhunt.com/passwords-evolved-authentication-guidance-for-the-modern-era/): detailed password guidance from Troy Hunt, creator of [haveibeenpwned.com](https://haveibeenpwned.com/),
- [We Didn't Encrypt Your Password, We Hashed It. Here's What That Means](https://www.troyhunt.com/we-didnt-encrypt-your-password-we-hashed-it-heres-what-that-means/): also from Troy Hunt — here he explains the difference between encryption and hashing.

## Brought to you by

{% include 'partials/authors-stack.njk' %}
