---
title: Learn Responsive Design
authors:
  - adactio
description: "A course exploring all aspects of responsive design. Learn how to make sites that look great and work well for everyone."
date: 2021-10-14
tags:
  - css
---

## Welcome to Learn Responsive Design!

This course takes you on a journey through the many facets of modern responsive web design. 
The first few modules will ease you in with a history of where responsive design came from and a look at the fundamentals of responsive layouts. 
From there, you’ll learn about responsive images, typography, accessibility and more.

Along the way you’ll find out how to make websites responsive to user preferences and device capabilities. 
By the end, you’ll also have an understanding of what the future might hold for responsive design.

Each module has demos and self-assessments for you to test your knowledge.

This course is created for beginner and intermediate designers and developers. 
A basic understanding of HTML and CSS should be enough. 
You don’t need to know any JavaScript. 
If you’re completely new to making websites, there's an 
[introduction to HTML](https://developer.mozilla.org/docs/Learn/HTML/Introduction_to_HTML) 
and another course to help you [learn CSS](/learn/css/).

Here's what you'll learn:

{% include 'partials/course-index.njk' %}

So, are you ready to learn responsive design? 

{% Aside %}
This course was written by [Jeremy Keith](https://twitter.com/adactio), with input and review from [Rachel Andrew](https://twitter.com/rachelandrew), [Una Kravets](https://twitter.com/Una), [Adam Argyle](https://twitter.com/argyleink), and [Camden Bickel](https://twitter.com/camdenbickel).
{% endAside %}

