---
title: Learn CSS
authors:
  - andybell
description: An evergreen CSS course and reference to level up your web styling expertise.
date: 2021-05-04
tags:
  - css
  - layout
---

## Welcome to Learn CSS!

This course breaks down the fundamentals of CSS into digestible,
easy to understand pieces.
Over the next few modules,
you'll learn how the core aspects of CSS work and how to use them effectively in your projects. Use the menu pane by the "Learn CSS" logo to navigate the modules.

You'll learn CSS fundamentals like the box model, cascade and specificity, flexbox, grid and z-index.
And, along with these fundamentals,
you'll learn about functions, color types, gradients, logical properties and inheritance
to make you a well-rounded front-end developer,
ready to take on any user interface.

Each module is full of interactive demos and self-assessments for you to test your knowledge.
In addition to learning through reading and demos,
there is an accompanying podcast episode for each topic as another way to learn and continue expanding your knowledge.

This course is created for beginner and advanced CSS developers alike.
You can go through the series from start to finish
to get a general understanding of CSS from top to bottom,
or you can use it as a reference for specific styling subjects.
For those new to web development overall, check out [Learn HTML](/learn/html/) to learn all about how to write markup and link your stylesheets.

Here's what you'll learn:

{% include 'partials/course-index.njk' %}

So, are you ready to learn CSS? [Let's get started](/learn/css/box-model/).

{% Aside %}
This course is written and edited by CSS community experts: [Andy Bell](https://twitter.com/piccalilli_), [Rachel Andrew](https://twitter.com/rachelandrew), [Una Kravets](https://twitter.com/Una), [Adam Argyle](https://twitter.com/argyleink), [Emma Twersky](https://twitter.com/twerske), [Camden Bickel](https://twitter.com/camdenbickel), and [Kevin Lozandier](https://twitter.com/KevinLozandier). [Rob Dodson](https://twitter.com/rob_dodson) and [Jiwoong Lee](https://twitter.com/jiwoong) shepherded the UX and production build, along with help from [Ewa Gasperowicz](https://twitter.com/devnook) and [Kayce Basques](https://twitter.com/kaycebasques).
{% endAside %}
