---
title: Learn Accessibility
authors:
  - cariefisher
description: An evergreen accessibility course and reference to level up your web development.
date: 2022-09-30
updated: 2023-01-12
tags:
  - accessibility
---

## Welcome to Learn Accessibility!

Digital accessibility, commonly abbreviated a11y, is about designing and
building websites and web apps that disabled people can interact with in
a meaningful and equivalent way.

This course is created for beginner and advanced web developers.
You can go through the series from start to finish
to get a general understanding of accessibility practices and testing,
or you can use it as a reference for specific subjects. If you read an
unfamiliar term, refer to our [glossary](/learn/accessibility/glossary).
For those new to web development overall, check out the
[Learn HTML](/learn/html) courses for fundamentals with markup and
[Learn CSS](/learn/css) courses for styling fundamentals.

**This is not a complete reference**. Each section introduces the section topic, provides context and examples. There will be links to topic references, such as [MDN](https://developer.mozilla.org) and
[WCAG](https://www.w3.org/WAI/standards-guidelines/) specifications, and other
[web.dev](/learn) articles. Each section will have a short assessment to help
people confirm their understanding.

Some accessibility best practices differ, based on the disability you're
addressing. It's important to understand your users and to
listen to people with disabilities when they tell you what they need.

We are open to your feedback! [Open a GitHub issue](https://github.com/GoogleChrome/web.dev/issues/new/choose)
and give as much information as you can so we can address it.

Here's what you'll learn:

{% include 'partials/course-index.njk' %}

So, are you ready to learn accessibility? [Let's get started](/learn/accessibility/why).

{% Aside %}
This course was written by [Carie Fisher](https://cariefisher.com/)
([Twitter](https://twitter.com/cariefisher) and
[LinkedIn](https://linkedin.com/in/cariefisher)), with input and review from
[Alexandra White](https://heyawhite.com)
([Twitter](https://twitter.com/heyawhite)), and
[Rachel Andrew](https://rachelandrew.co.uk/)
([Twitter](https://twitter.com/rachelandrew)). Special thanks to
[Mark Steadman](https://twitter.com/Steady5063) for providing additional support
for the [JavaScript module](/learn/accessibility/javascript/), and 
[Aaron Forinton](https://github.com/aaronforinton) for supporting the publication process.
{% endAside %}
