---
title: 'Glossary'
authors:
  - cariefisher
description: Learn common accessibility terms and concepts.
date: 2022-09-30
tags:
  - accessibility
---

In this document, you'll find common terms and concepts related to accessibility.

## A11y

[A11y](https://www.a11yproject.com/posts/a11y-and-other-numeronyms/) is 
numeronym for accessibility (a + 11 letters + y). Typically pronounced as 
"ally" as in "a person or group that provides assistance and support in an 
ongoing effort, activity, or struggle," giving the term "a11y" multiple 
meanings.

## Accessibility Conformance Report (ACR) {: #acr} 

The [ACR](https://tetralogical.com/blog/2021/10/15/introduction-to-accessibility-conformance-reports/)
is the final report presented to a client once a full ACT has been performed.
If you need a legally binding version of the ACR, you would utilize a version
of the [Voluntary Product Accessibility Template (VPAT)](#vpat).

## Accessibility Conformance Testing (ACT) {: #act}

[ACT](https://www.w3.org/WAI/standards-guidelines/act/) is commonly referred to
as an accessibility audit. The ACT utilizes various testing methodology and
tools: primarily automated, manual, and [assistive technology](#AT) (AT)
devices.

ACT is first performed as a baseline metric to gauge general
accessibility compliance of a digital product. It's often run multiple times
throughout the software product lifecycle to check for changes in the level of
conformance against a set of pre-determined accessibility checkpoints or 
guidelines. 

## ARIA

[ARIA](https://www.w3.org/WAI/standards-guidelines/aria/) is an acronym for
Accessible Rich Internet Applications (formally known as WAI-ARIA—Web
Accessibility Initiative Accessible Rich Internet Applications). ARIA is a
specification written by the W3C, defining a set of attributes that you can add
to HTML elements to support accessibility. These attributes communicate role,
state, and property to assistive technologies via accessibility APIs
implemented in the accessibility tree in modern browsers.

## Assitive technology (AT) {: #at}

[AT](https://en.wikipedia.org/wiki/Assistive_technology) is hardware and
software that can be no-tech (such as a mouthstick), low-tech (such as a 
keyboard), or high-tech (such as a screen reader). AT is used to help increase, 
maintain, or improve the capabilities of performing a task for a person with 
disabilities. AT includes braille keyboards, audio browsers, screen magnifiers, 
and alternative pointing devices.

## Digital accessibility

[Digital accessibility](https://www.w3.org/WAI/fundamentals/accessibility-intro/) is the 
practice of building digital products in a way that all users, regardless of 
their disability, will have equal access to the content or functionality of the 
product.

## POUR

[POUR](https://www.w3.org/WAI/fundamentals/accessibility-principles/) is 
shorthand for Perceivable, Operable, Understandable, and Robust, which are the 
foundational human-focused principles of WCAG.

## Screen reader

A [screen reader](https://www.afb.org/blindness-and-low-vision/using-technology/assistive-technology-products/screen-readers)
is a high-tech assistive technology that uses synthetic language to read and 
navigate digital documents for people with low or no vision, cognitive issues, 
and other disabilities.

* Desktop
    * [ChromeVox](https://support.google.com/chromebook/answer/7031755) (ChromeOS)
    * [JAWS](https://www.freedomscientific.com/Products/software/JAWS/) (Windows)
    * [Narrator](https://support.microsoft.com/en-us/windows/complete-guide-to-narrator-e4397a0d-ef4f-b386-d8ae-c172f109bdb1) (Windows)
    * [NVDA](https://www.nvaccess.org/) (Windows)
    * [Orca](https://wiki.gnome.org/Projects/Orca) (Linux)
    * [VoiceOver](https://www.apple.com/accessibility/vision/) (macOS)
* Mobile
    * [TalkBack](https://support.google.com/accessibility/android/answer/6283677?hl=en) (Android)
    * [VoiceOver](https://www.apple.com/accessibility/vision/) (iOS)
* [Screen Reader Keyboard Shortcuts and Gestures](https://dequeuniversity.com/screenreaders/)

## VPAT

[VPAT](https://en.wikipedia.org/wiki/Voluntary_Product_Accessibility_Template) 
is shorthand for Voluntary Product Accessibility Template. A VPAT is a template 
to draft an [Accessibility Conformance Report](#acr) (ACR). An ACR clearly 
states which accessibility standards a product or service meets and warns users 
about any "accessibility blockers" they may encounter. A VPAT does not mean 
that a digital product is 100% accessible: it is just a report of the state 
of a product from an accessibility conformance perspective.

## Web Accessibility Initiative (WAI)

The [Web Accessibility Initiative (WAI)](https://www.w3.org/WAI/) is a 
sub-group of the W3C focuses only on digital accessibility. 

## Web Content Accessibility Guidelines (WCAG) {: #wcag}

Web Content Accessibility Guidelines (commonly referred to as ]=
[WCAG](https://www.w3.org/WAI/standards-guidelines/wcag/)) is an international 
set of accessibility standards developed through the W3C in cooperation with 
individuals and organizations. The goal of WCAG is to provide a single shared 
standard for digital accessibility that meets the needs of individuals, 
organizations, and governments worldwide.
