---
title: 'Conclusion and next steps'
authors:
  - cariefisher
  - alexandrawhite
  - rachelandrew
  - marksteadman
description: Further resources to help you take your next steps.
date: 2023-01-12
tags:
  - accessibility
---

Congratulations, you've made it through Learn Accessibility! At this point,
you've learned a lot of best practices for accessibility and gone through
multiple rounds of accessibility testing. You may have learned some new
terminology or refreshed your memory in our
[glossary](/learn/accessibility/glossary/).

We hope you are confident applying these lessons to your websites and web
applications.

## Additional resources

To continue building your accessibility knowledge, we recommend the following
resources:

* [Web Accessibility Initiative (WAI)](https://www.w3.org/WAI)
* [Web Content Accessibility Guidelines (WCAG) from the W3C](https://www.w3.org/WAI/standards-guidelines/)
* [WCAG Quick Reference Guide](https://www.w3.org/WAI/WCAG21/quickref)
* [Accessibility on MDN](https://developer.mozilla.org/docs/Web/Accessibility)
* [Deque University Digital Accessibility Courses & Accessibility Reference Library](https://dequeuniversity.com/)
* [Global web accessibility laws](https://www.w3.org/WAI/policies/)
* [A11y talks](https://a11ytalks.com/)
* [List of accessible patterns from Smashing Magazine](https://www.smashingmagazine.com/the-smashing-newsletter/smashing-newsletter-issue-289/)
* [How to fund accessibility work](https://pleasefunda11y.com/)
* [A11y automation tracker](https://a11y-automation.dev/)
* Google developer documentation style guide
    * [Write accessible documentation](https://developers.google.com/style/accessibility)
    * [Write inclusive documentation](https://developers.google.com/style/inclusive-documentation)

More resources can be found throughout the modules, as related to each topic.

## Community highlights

We conducted several interviews with accessibility practitioners in 2022. Read about their journey to accessibility and best practices:

* [Melanie Sumner](/community-highlight-melanie/) told us about her journey
  into engineering, accessible design, Ember.js, and the importance of funding
  these efforts.
* [Olutimilehin Olushuyi](/community-highlight-shuyi/) told us about his
  transition from the law to web development, building accessible community,
  and creating accessible layouts.
* [Albert Kim](/community-highlight-albert-kim/) told us about mental health 
  awareness, building for invisible disabilities, the  COGA Accessibility
  Community Group, and more practical wisdom.
* [Elisa Bandy](/community-highlight-elisa/) told us about her work for
  Google's internal documentation, how to prioritize use cases, and building
  expertise.

## Brought to you by

{% include 'partials/authors-stack.njk' %}

### Special thanks

Thank you to Aaron Forinton for supporting the publication of several modules
and assessments.
