---
layout: handbook
title: Word list
date: 2019-06-26
updated: 2022-07-11
description: |
  Spelling, punctuation, and capitalization for words and phrases commonly used on web.dev.
---

This word list tells you how to spell, punctuate, and capitalize common words in web.dev content.
This word list supplements the [Google Developer Documentation Style Guide Word List](https://developers.google.com/style/word-list) (GDDSGWL).
If a word is listed in the GDDSGWL but not here, use that spelling. If a word is listed both here and the
GDDSGWL, use the spelling that you see here.

* code splitting (noun)
* code-splitting (adj)
* DevTools, Chrome DevTools
* e-commerce
* FFmpeg
* home screen
* Hypertext Markup Language (HTML)
* internet
* JavaScript
* JPEG image
* lazy-load
* npm
* one-way trip (noun)
* one-way-trip (adj; avoid if possible)
* origin trial
* PageSpeed Insights
* preconnect
* referer (so spelled when referring to [the HTTP header](https://tools.ietf.org/html/rfc7231#section-5.5.2))
* round trip (noun)
* round-trip (adj)
* service workers
* web
* web app manifest
* web page
* web.dev
* WebFont
* webpack
* website
* Wi-Fi

## Words to avoid

In this list are some words to avoid, along with alternative suggestions.

* code-split (verb): use _split_
* guide: use _post_
* spec: use _specification_

## Terminology

Proper user of terminology is necessary so readers can consistently understand the state or nature of concepts and APIs across web.dev as they relate to the web. Below are some terms that you, as a writer should understand the meaning when writing content:

- "Core Web Vitals" refers only to three metrics: Cumulative Layout Shift (CLS), Largest Contentful Paint (LCP), and First Input Delay (FID). Any other metrics are not "Core Web Vitals" or even "Web Vitals", they are simply "metrics".
- Avoid using the term "Web Vitals" when you mean "Core Web Vitals".
