---
layout: handbook
title: Voice
date: 2019-06-26
updated: 2020-07-24
description: |
  A description of the primary voice for web.dev writing.
---

The voice of web.dev is:
* **Knowledgeable.** We have deep expertise in the topics we discuss. We offer clear rationales for our choices, but we acknowledge other choices when they exist.
* **Humble.** We know a lot, but we don't know everything. We have as much to learn from our readers as they have to learn from us.
* **Sympathetic.** We understand the common problems developers face. We're developers too.
* **Friendly.** We're here to help, and we enjoy doing it. We keep our advice conversational and down-to-earth.

All web.dev writing should have these characteristics, but you should also feel free to show your own personality as long as your content adheres to the guidelines in this handbook. (Most importantly, content should always be clear and inclusive.)

Examples of pieces with a personal voice we like:
* [JavaScript Promises: An Introduction](https://developers.google.com/web/fundamentals/primers/promises), by Jake Archibald
* [The Gift of Giving Up](https://dev.to/chromiumdev/the-gift-of-giving-up-1lgl), by Sam Thorogood

Making content engaging while remaining [inclusive](/handbook/inclusion-and-accessibility) can sometimes be challenging; for example, a reference to an American TV show might not be clear to an international audience, no matter how perfectly it illustrates an idea.

It's great to include details that convey your interests or your journey as a developer—just make sure they don't get in the way of the concepts you're teaching. Use these details sparingly—maybe 2–3 per piece.

Examples:
* A fun image for your contributor profile
* An animated gif conveying a common emotional response to an aspect of what you're teaching
* An emoji to punch up a key sentence 🤔
* A code block that's practical while showing some personality
* A use case that shows your background while still being generally relevant

## Emojis

It's OK to use emojis in moderation in your web.dev content. To be precise, 3 emojis per page is always
OK. If you want to use more than 3 emojis on your page, the web.dev content lead will decide
on a case-by-case basis.

Here's our rationale for allowing emojis:

* There's no evidence that emojis interfere with the learning process.
* Some of our contributors feel that using emojis is an important part of their self-expression.
* The [Style and authorial tone](https://developers.google.com/style/tone) page of the
  Google Developer Documentation Style Guide has no opinion about the use of emojis.
* Part of [Google's philosophy](https://www.google.com/about/philosophy.html) is
  "you can be serious without a tie."
