---
layout: handbook
title: Write effective instruction
date: 2019-06-26
description: |
  Learn strategies for writing effective instruction on web.dev, especially for adult learners.
---

Most web.dev content includes at least some instruction. These guidelines help make your instruction easy to follow.

Explain _why_ to do something before explaining _how_ to do it. Knowing the end goal helps readers understand the purpose of individual steps.

Keep the scope of instruction manageable. If a task is complex, find ways to chunk the steps. For example, provide the essential pieces in a post and put the ancillary pieces in one or more codelabs.

Always provide examples for complex or abstract concepts. If you're debating whether to give an example, add one.

Use web.dev's built-in [Instruction components](/handbook/web-dev-components#instruction) for common tasks that are often referenced on the site (for example, instructions about opening Glitch or Chrome DevTools). This approach provides a consistent user experience and makes it easy to update instructions across the site when needed.

## Instruction for adult learners
Adult learners bring a lot experience. It's important to honor that experience while acknowledging the challenges of the tasks you're teaching. 

Be mindful of [voice](/handbook/voice). To avoid alienating your readers, try to strike a balance between showing expertise and humility.

Avoid words and phrases that make it sound like a concept or task is easy or obvious—it may not be! For example, the following words and phrases can frustrate readers when a task turns out to be harder: _obviously_, _simply_, _of course_, _clearly_, _just_, _everyone knows_, and _easy_.
