---
layout: handbook
title: Case study guidelines
authors:
  - kaycebasques
date: 2021-01-26
---

The goal of this guide is to help you write effective case studies.

## web.dev's goal for case studies {: #goal }

**Our goal is to persuade web developers to make a change**. The best way to do
that is to focus on how the reader's life will get better if they make the
change.

We understand that the partner's motivation is usually to increase awareness of
their company or product. We believe that it's in the partner's best interest to
not focus on themselves too much. By focusing on what's in it for web developers (the
people who are most likely to read our case studies), we maximize the odds that
people actually read and share the case study.

## Find a compelling correlation {: #correlation }

A very effective approach for case study messaging is to highlight a correlation
between the changes that the web developers made and a business metric
improvement. Examples:

* [Clipchamp's video editor PWA installs see a 97% monthly growth](/clipchamp/)
* [PWA users are 2.5x more likely to purchase Gravit Designer PRO](/gravit-designer/)
* [JD.ID improves their mobile conversion rate by 53% with caching strategies, installation, and push notifications](/jdid/)
* [Rakuten 24's investment in PWA increases user retention by 450%](/rakuten-24/)
* [How focusing on web performance improved Tokopedia's click-through rate by 35%](/tokopedia/)

The reason this is important is because web development teams often need to
persuade business stakeholders before they can make any significant changes
to their website or processes. Business stakeholders won't agree to these
changes unless there is evidence that the ROI is worthwhile.

## Organize the beginning of your content as an inverted pyramid {: #inverted-pyramid }

The [inverted pyramid](https://www.nngroup.com/articles/inverted-pyramid/)
is a journalism best practice. Organize your content so that the most
important information is at the top, and the least important at the bottom.

Think about it this way: 100K people might see a link to your case study
on social media. 50K of those people actually open the link. And only 5K
actually read through the whole thing.

### Title {: #title }

The title is the single most important part of your case study because
it's what the greatest amount of people see. It should be focused
around your [compelling correlation](#correlation).

In other words, most case study titles should have these 3 parts:

* The name of the company
* The web development change(s) they made
* The business metric improvement correlated to the change(s)

### Subtitle {: #subtitle }

The subtitle (or subhead) is the text that appears below the title. See
[subhead](/handbook/yaml-front-matter/#subhead) for an example. It also shows up
on the [blog homepage](/blog) and is the text that we suggest to search engines
to present on Search Engine Results Pages. Therefore this is the second most
important part of your case study (because it's the second-most-seen text).

The subtitle is a good place to share other noteworthy correlations
([example](/gravit-designer/)). Or, you can elaborate on the story that you
began to tell in the title ([example](/betty-crocker/)).

### Introduction {: #introduction }

The reader, especially business executives, expect the first paragraphs of the
content to provide a summary of the most important information. A good way to
ensure that you provide all important information is to systemetically answer
the [Five Ws and How][five].

Avoid the urge to talk too much about the partner. It's OK to share some context
(1-3 sentences) so that the readers understand what the company/product does. If
it gets too long, though, it begins to sound like a sales pitch.

## General organization {: #organization }

After you have optimized your title, subtitle, and introduction, we can give you
more flexibility around how you organize the rest of your ideas. In other words,
you don't need to strictly follow an inverted pyramid approach throughout the
entire case study.

The [Scale on web case studies][scale] use the following pattern:

* Highlighting the opportunity
* The tools they used
* Overall business results

The [BookMyShow case study](/bookmyshow/)
demonstrates another common organization:

* Challenge
* Solution

## Hero images {: #hero }

A well-designed hero image is a good way to make your case study look
attractive and professional. In general, the web.dev team doesn't have resources
to create custom hero images for you. See [Hero images](/handbook/markup-media/#hero)
for dimension requirements.

## Cross-posting {: #crossposting }

If your case study has already been published on another site and you'd like to mirror it on web.dev, then whether your case study gets published here becomes more complicated.

In particular, requesting to cross-post articles that have already been posted on self-publishing outlets such as personal blogs are problematic, as the web.dev editorial team has a rigorous editorial process. This means that the final version of your proposed case study will likely be significantly different than what you have already published.

There is also the concern of what version is canonical. While the web.dev team wants to publish compelling case studies, canonicity is important, as it can raise issues when it comes to how your article is indexed if you don't take care to mark [which version is canonical](https://developer.mozilla.org/docs/Web/HTML/Attributes/rel#canonical).

Generally speaking, you should avoid proposing case studies which have already been published elsewhere. While there may be exceptions to this rule, they are few and far between, and must be cases in which the original version has not been self-published, and is already marked as the canonical version.

## Examples {: #examples }

The [Scale on web case studies](/tags/scale-on-web/) case studies are the best case studies
we've produced to date, in terms of aligning with the case study guidelines.

You can check out [all of our case studies](/tags/case-study/) for more ideas,
but be aware that they may not follow the case study guidelines as
closely as the [Scale on web case studies][scale] do.

## Deliverables {: #deliverables }

When submitting the first draft of your case study, please submit it as a Google
Doc. This helps to ensure that editorial feedback is communicated in a
consistent way in a format that is familiar for Googlers.

While not _strictly_ necessary, it helps to streamline the process if source
files for figures can be provided. However, if the person responsible for
writing the case study doesn't have domain knowledge in using image editors,
the technical writing team is capable of extracting images from Google Docs if
necessary.

[five]: https://www.workfront.com/blog/project-management-101-the-5-ws-and-1-h-that-should-be-asked-of-every-project
[scale]: /tags/scale-on-web/
