---
layout: post
title: Fixing website speed cross-functionally
subhead: How other departments can help make your website speed optimization project a bigger success.
authors:
  - linahansson
description: How other departments can help make your website speed optimization project a bigger success.
date: 2020-02-28
tags:
  - performance
---

One common myth connected to site speed is that it's only the development team's responsibility. The
reality is that a fast site requires help from several departments. Developers can rarely solve the
issues alone, no matter how talented they are. So how do you fix speed together with your
colleagues? This article explains how you (as a web developer) can convince your company
to prioritize site speed, get help from different departments while optimizing, and increase awareness
of your optimization project's success.

{% Aside %}
This guide has a slight focus on e-commerce (particularly the business stakeholders section), but a
lot of the guidance is general enough to be useful to any website that wants to improve mobile conversions.
{% endAside %}

## Fix speed with the help of your business stakeholders {: #stakeholders }

Many companies are in the middle of a disruptive shift in consumer behavior, where the growth of
people buying on digital platforms instead of physical stores tells the tale that companies need to
adjust quickly or risk facing decreasing revenue. This will require both new organizational
processes and mindsets, and a strong buy-in from the stakeholders in order to succeed.

### The shared challenge

The way companies organize themselves will most likely need to change within several levels. First
of all, a speed project, with the potential uplift in revenue that it can create, will be difficult
to perform without developers getting time to work on it. The resource allocation needs to be in
place, and the collaboration with other departments such as marketing and web designers will often
go smoother if stakeholders and executives show that it's a priority project.

Apart from this operational level, it's also important for stakeholders to understand that there are
two shifts happening right now:

-  Even though a larger proportion of your sales
   might come from the physical stores, [most customers will use a digital platform such as your
   site before the purchase in the stores](https://www.thinkwithgoogle.com/marketing-resources/micro-moments/meet-needs-i-want-to-know-moments/).
   If the site doesn't give visitors a good user experience, then the revenue in physical stores
   risk suffering as well. Plus, studies show that it also affects
   [customers' willingness to recommend your business and their loyalty to your
   business](https://www.thinkwithgoogle.com/intl/en-154/marketing-collections/mobile/why-mobile-speed-means-loyal-customers-and-how-make-it-happen/).

-  The growth of mobile visitors is stronger than desktop visitors, making mobile-first either a
   current or future state to prepare for. Also, there's a strong correlation
   between site speed and conversions on mobile, with
   [one study from SOASTA showing that for every second delay in mobile page load,
   conversions can fall by up to 20%](https://www.thinkwithgoogle.com/data/mobile-page-speed-conversion-data/).

This means that companies that make executive decisions informed by the people who are experts on
digital platforms will have an edge. One suggestion could thereby be to invite one developer
to the meetings where business decisions are being made, to ensure that the site and its
constraints are being considered from the start, and that way, secure increased sales.

### Send a proposal to your stakeholders

> In general, around 10% of sales happen on digital platforms, but studies show that as much as
> [85% of the sales in physical stores are influenced digitally first](https://www.thinkwithgoogle.com/marketing-resources/micro-moments/meet-needs-i-want-to-know-moments/).
> Having a site that performs well, especially on mobile (which is becoming the primary device), is
> thereby crucial for our business's revenue. We propose a speed project that will help the site
> increase conversions, and to set up streams of communication so that the insights in technical
> teams can be better put to use before decisions that will affect the site are made.

### Prepare for meeting with your stakeholders

Before meeting with stakeholders, make sure you're prepared with data for your website and your
competitors' sites, and data that demonstrates high ROI for the changes you're suggesting.
Gather data around the importance of speed. The best scenario is if it's connected to the company's
revenue. Here are some ways to achieve this:

-  **Calculate your relative mobile conversion rate**.
   Work with your analytics team and perform the analysis described in [The value of speed][value]. If
   you historically have one period (at least 2-3 months) when the load times have been much
   higher than another period of equal length, then the slow site speed will usually have affected
   mobile conversions heavily. Through the analysis you can calculate how much revenue the company
   lost during the period of bad speed, proving the value of speed. If load times have stayed at
   about the same level, the analysis will be difficult to perform and the below alternatives can
   give more answers.
-  **Estimate the value of speed from statistical models**.
   With the help of Google's [TestMySite](https://www.thinkwithgoogle.com/feature/testmysite) you
   can run a test and then calculate the impact that a faster site can have on your business. All
   you need is data around average monthly visitors, conversion rate, and average order value, which
   your analytics team can help you with.
-  **Provide best practice case studies**.
   You can also use cases from other companies, who've made their site faster and seen the effect.
   [How Page Load Time Affects Conversion Rates: 12 Case Studies](https://blog.hubspot.com/marketing/page-load-time-conversion-rates)
   provides some examples.
-  **Show the importance of mobile**.
   Ask the analytics team to provide data around what percentage of your traffic comes from mobile versus desktop.
-  **Research how much it will cost**.
   The above calculations are ways to show stakeholders the possible revenue uplift from speed, but
   in order for stakeholders to make decisions they need to know the ROI, so if you come prepared
   with an estimated cost then the executive decision can be reached faster. To do this, evaluate
   how long the initial focused speed project will take, and how much time you will need for
   maintenance afterwards. For instance,
   in [Fast-forward thinking: TUI speed up their site by breaking down silos](https://www.thinkwithgoogle.com/intl/en-154/insights-inspiration/case-studies/fast-forward-thinking-tui-speed-their-site/),
   the developers were given 20% of their time free from backlogs and campaigns, which they could
   devote to speed projects and other ways of making the site better.

### Meet with your stakeholders

-  **Present how much traffic you are getting from mobile versus desktop, and the growth you've had
   from mobile the last few years**. This showcases the importance of creating a great mobile experience.
-  **Present your findings on how speed influences the company's revenue**.
-  **Let the stakeholders know that the developers can help increase revenue from the mobile
   visitors** if they are given time to work on speed continuously.
-  **Suggest that one person from the development team should be invited to executive meetings
   where decisions around the site will be taken**. Nowadays we sell on digital platforms. The
   winners will be the companies who start communicating with their digital experts. Modern
   companies will need to have communication streams set up between departments and between
   stakeholders and developers.
   [A study by the Harvard Business Review](https://hbr.org/2011/09/why-your-it-project-may-be-riskier-than-you-think)
   showed that one in six IT projects has a cost overrun of 200%. One example was Kmart, which was
   losing its competitive position to Walmart and Target when it began its $1.4 billion IT
   modernization project in 2000. By setting up communication and maintenance early, silos can be
   broken down and knowledge sharing can become a competitive advantage.

## Fix speed with the help of your marketing team {: #marketing }

### The shared challenge

Marketing teams need tools to handle ads and data in order to make informed decisions, but most
tools slow down websites and are often implemented with render-blocking scripts which makes visitors
who enter the site have to wait until they see anything on the screen. There is therefore a need for
a balance; the marketing department needs data and tools, but for the site to get low bounce rates
and high conversion rates it has to be fast, so that marketing gets a good return on their
investments.

The balance is achieved by being careful with scripts:

-  Avoid duplicates that measure approximately the same thing.
-  Remove tools that are no longer used.
-  Don't measure "nice-to-have" things. Only measure business-critical things.

Since it's difficult for the developers to know what the marketing department is dependent on, and
since the marketing department might not know which tools are especially heavy for the site, you
need to collaborate.

### Send a proposal to your marketing team

> Tools used for tracking and ads often block how quickly visitors see content when they enter the
> site. This reduces the value of marketing investments, since we pay for ads, people get
> interested, they click but then have to wait. This risks them getting annoyed and leaving. [One
> study](https://www.slideshare.net/nicjansma/reliably-measuring-responsiveness) found that
> conversion rate decreased from around 50% to around 35% when the speed metric [Time to
> Interactive](/tti) increased from 0.15 s to 0.3 s. Can we work together on solving this to create a
> balance between the tools you need and site performance, making increased return on marketing
> investments a result?

### Prepare for meeting with your marketing team

-  **Create a list of the scripts that are implemented on the
   site**.
-  **Send the list to marketing and ask them to take a look at it in advance and sort them into
   three buckets**:
   -  **Business-critical**. These scripts must stay.
   -  **Nice-to-have**. Scripts that might be able to be used less or removed. For instance,
      sometimes companies collect heat maps or screen
      recordings, but the data might only be reviewed infrequently and not lead to action or
      increased conversions. In cases such as these it can be better to agree to only run the tools
      for (say) two weeks, collect the insights for analysis, then clean out the scripts until it's
      time for the next period of focused data collection.
   -  **Not used or not owned**. These should be removed.
-  **Check how much each script slows down your site by comparing site speed with and without it**.
   In [WebPageTest](https://www.webpagetest.org/) this can be set up
   via the [Block tab in Advanced Settings](https://andydavies.me/blog/2018/02/19/using-webpagetest-to-measure-the-impact-of-3rd-party-tags/).
   Or you can [block network requests in Chrome DevTools](https://developer.chrome.com/docs/devtools/network/#block).

### Meet with your marketing team

-  **Go through the list of scripts and give your view on each script**.
   For instance, are any of the nice-to-have scripts very damaging to site
   performance? By receiving recommendations it's easier for the marketing team to prioritize, and
   by hearing about what is business-critical for them it's easier for you to understand their point of
   view.
-  **Discuss the following topics**:
   -  Are the benefits of the data collected leading to an uplift in conversions that exceeds
      the decrease caused by the site getting slower? Data can guide the decision.
   -  Has your company chosen a provider that has the fastest version of the tool on the
      market? The marketing department might need help from developers to work out whether
      business critical tools can be replaced by faster alternatives.
   -  Are there alternatives to any of the scripts on the site? For instance, instead of
      heatmaps it might be possible to start doing [usability
      tests](https://winonmobile.withgoogle.com/5-qualitative-research/#content) where you also
      hear about the "why" behind user behavior, often leading to deeper insights.

{% Aside %}
One common challenge is that be that people become defensive when approached with suggestions.
The key might be to always emphasize respect for the knowledge areas of other departments.
By formulating that you want to understand and listen, an openness can be created for listening
to your ideas as well. And finally, try inviting other teams to social gatherings or coffee and
bakery with different discussion topics. Sometimes the most powerful meetings take place outside the meeting room.
{% endAside %}



### Agree on next steps

-  **Decide on a process moving forward**. Should marketing always ask the developers to review new
   tools and their impact on speed before implementation? Or should marketing get a performance
   budget where they learn how to check speed and they themselves can prioritize which tools they
   want as long as they meet the speed target?

## Fix speed with the help of your web design team {: #design }

One of the biggest challenges for web performance is that while connectivity might be getting faster
in many regions, [websites are becoming
heavier](https://speedcurve.com/blog/web-performance-page-bloat/) and as a result actually getting
slower. Developers need to collaborate with web designers in order to solve this.

### The shared challenge

In the end, all departments within a company are usually dependent on the site leading to
conversions, whether that's for revenue generation or something else. And the harsh truth is that
it doesn't matter how beautiful web pages are if they take such a long time to load that people
don't stick around to see them.

But slim web pages are a shared responsibility. Developers can use various image optimization techniques
to make images load faster. Web designers can create pages that help keep page weight below an
agreed level.

### Send a proposal to your web design team

> Studies show that pages with fewer images and less elements create more conversions. For example,
> [a study by Google and SOASTA](https://www.thinkwithgoogle.com/marketing-resources/experience-design/mobile-page-speed-load-time/)
> found that sessions that converted users had 38% fewer images than sessions
> that didn't convert. Can we work together to reach speed targets and set up a joint
> collaboration that can increase conversions on the site? Examples of what we can achieve
> together include finding the right level of image compression with a balance between quality and
> speed, or reducing complex layouts or functionalities that often result
> in heavy, slow sites.

### Prepare for a meeting with your web design team

-  **Track which pages on the site have the highest load time and highest page weight**. For
   instance, if you're working with an e-commerce site, make sure you check not just the home page,
   but also any campaign pages, some of the biggest category pages, some of the product pages, and
   the checkout flow.
-  **Prepare a [performance budget](/performance-budgets-101) proposal for the
   designers**. One alternative is to start as simple as possible with page weight as the metric and
   set 1 MB as the target for all pages (or 1.5 MB if branding is very important for conversions).
-  **Prepare a list of which pages end up above the target page weight level**.

### Meet with your web design team

-  **Commit to investigating how the development team can deliver images faster through
   [various image optimization techniques](/fast/#optimize-your-images)**, such as image compression,
   responsive images, image resizing, lazy loading, caching, and server optimization.
-  **Create a test page where images are published in
   different image qualities and dimensions, and agree on a level that balances performance and
   quality on different screens**. Remember that visitors on mobile often have short session length,
   with one study showing that [more than half of mobile sessions are 30 seconds or shorter](http://ubicomp.oulu.fi/files/mobilehci14.pdf).
   These users might not study images in detail and might prefer the site to be fast.
-  **Propose a performance budget** where the web designers commit to making sure that all web
   pages have a page weight below 1 MB (or at maximum 1.5 MB).

## Fix speed with the help of your analytics team {: #analytics }

Businesses need data to know what to focus on and to get a basis for decisions. But even though many
talk about the importance of site speed and its connection to revenue and sales, there are still
many companies that don't include speed in their weekly reports outside tech teams. This can be
changed if developers start collaborating with analytics teams.

### The shared challenge

The reality is this: what's not reported will not be focused on. If site speed is not part of
weekly or monthly reports to business stakeholders, it will easily be forgotten and you will have a hard time
getting resources to focus on it. But since analytics teams often aren't experienced with tracking speed, they will need
help from developers. And the developers will need help from the analytics team to calculate the
effect on revenue when speed improvements are made. These departments are more dependent on each
other than one might at first think.

### Send a proposal to your analytics team

> Many [case studies](https://blog.hubspot.com/marketing/page-load-time-conversion-rates) show the
> effect site speed has on revenue and bounce rate. Could we possibly collaborate to set up site
> speed tracking for our company, and perhaps get speed as a part of the reports going to
> stakeholders so that we get more buy-in?

### Prepare for a meeting with your analytics team

-  **Track speed regularly**. One recommendation is to use an API with a tool like [Lighthouse CI](https://github.com/GoogleChrome/lighthouse-ci),
   [PageSpeed Insights](https://developers.google.com/speed/docs/insights/v5/get-started), or
   [WebPageTest](https://github.com/andydavies/WPT-Bulk-Tester), enabling you to collect stats
   regularly in a controlled lab setting for easy benchmarking across different time periods.
-  **Forward [The value of speed][value] to the analytics team
   and ask if they can perform the analysis** so that you have the chart ready to be analyzed during
   the meeting.

### Meet with your analytics team

-  **Check the chart created from [The value of speed][value]**.
   Relative mobile conversion rate is one way of
   tracking the impact of speed and how your site is improving. Ask the analytics team if they're open to start
   tracking this.
-  **Decide if the load time metric in Google Analytics is good enough for simplified business reports**.
   [The value of speed][value] uses this metric. As many developers
   know, this is only one of many important [speed metrics](/metrics/), and since it's in Google Analytics it's also [field
   data](/user-centric-performance-metrics/#in-the-field) instead of [lab data](/user-centric-performance-metrics/#in-the-lab).
   But, is it good enough to be used for simplified business reports?
   Check the result you get from the analysis above, and see if it is possible to observe the
   relative mobile conversion rate going down when load times have been high for at least 2–3
   months, and if the relative mobile conversion rate goes up when load times have been low for 2–3
   months. If your load times have remained pretty stable, it will be difficult to know if the
   analysis is working for you until you've improved speed heavily. If so, go with the next
   alternative.
-  **Show your charts for the speed metrics the developers use**. Explain them to the analytics team
   and see if you discover correlations with the conversion rate or the relative mobile conversion
   rate.
-  **Give the analytics team time to think about ways to use speed in
   calculations connected to revenue and how to report this to stakeholders**. This is often a new topic for them.
   Then meet again and try out an approach that you agree upon. As always, you need to revise data collection until you
   find the right fit, but this is a way to start the collaboration.

### Next steps

Ask your analytics team to perform the analysis outlined in [The value of speed][value] after the speed
project has led to big improvements. It will show the company how much more conversions and revenue
it has gained, rewarding your team as well as all of the departments that collaborated with you.
This can be included in a weekly report to stakeholders, so the project doesn't
become a one-off effort but is continuously maintained.

[value]: /value-of-speed/
