---
layout: post
title: How to measure search engine optimization with Lighthouse
authors:
  - ekharvey
date: 2018-11-05
description: |
  The Lighthouse SEO audit scans your page, tests for things that matter to
  search engines, and gives you a score so you can see specific areas for
  improvement. SEO matters because it's how you get more relevant users viewing
  your content.
web_lighthouse: N/A
---

## Why does this matter?

The Lighthouse search engine optimization (SEO) audit scans your page, tests for
things that matter to search engines, and gives you a score so you can see
specific areas for improvement. SEO matters because it's how you get more
relevant users viewing your content. If a search engine has trouble seeing your
page, you're possibly missing out on traffic sources.

## Audit your page with Lighthouse

Run Lighthouse on a page that's representative of the content that you want
search engines to see:

{% Instruction 'audit-seo', 'ol' %}

Lighthouse generates a report for your page so you can see areas where you can
improve SEO for your site.

To learn how to fix issues flagged by Lighthouse, see the
[SEO audits](https://developer.chrome.com/docs/lighthouse/seo/) collection.

## Next steps

It's worth noting that the audit doesn't cover everything you could do to
increase visibility in search engines. You'll have to check the guidelines for
individual search engines because they may have different requirements.

Here are some guides for specific search engines:
- [Bing](https://www.bing.com/webmaster/help/webmaster-guidelines-30fba23a)
- [Google Search](https://support.google.com/webmasters/answer/35769)
- [Yandex](https://webmaster.yandex.com/)

There are also non-technical aspects that can improve visibility of your content
in search engines, such as writing in the style of your target audience. Bottom
line: make great content for the people you want to attract.

To learn more, check out Google's I/O talks:

- [Build a successful web presence with Google Search](https://www.youtube.com/watch?v=NO-sdBzb1Hc)
- [Deliver search-friendly JavaScript-powered websites](https://www.youtube.com/watch?v=PFwUbgvpdaQ)
