---
layout: post
title: Web Developer Satisfaction
description:
  Web Developer Satisfaction is a Google project to gather information about
  the needs of web developers. The goal is a more reliable, predictable and
  interoperable web platform, enabling developers to invest in and trust it,
  and adopt and use new features to grow the platform and their business.
date: 2021-03-22
updated: 2021-03-23
---

Web Developer Satisfaction, shortened DevSAT, is a Google project to gather
information about the needs of web developers. Our goal is to make sure
developers are being heard, know what's happening with their feedback, and see
issues being addressed. DevSAT is how we ensure we are focusing on the right
areas with our Engineering and Developer Relations work. The goal is a more
reliable, predictable, and interoperable web platform, enabling developers to
invest in and trust it, and to adopt and use new features to grow the platform and
their business.

## Ongoing research to understand developer needs

+   [MDN DNA (Developer Needs Assessment) surveys](https://insights.developer.mozilla.org/)
+   [MDN Browser Compatibility Report 2020](https://insights.developer.mozilla.org/reports/mdn-browser-compatibility-report-2020.html)
+   MDN Web Testing Research is in progress, results will be announced soon

## 2021 focus on compatibility

Compatibility on the web has always been a big challenge for developers. The
goal in 2021 is to eliminate browser compatibility problems in five key focus areas
so developers can confidently rely on these areas not having bugs. This effort
is called [#Compat2021](https://twitter.com/search?q=%23compat2021&src=typed_query&f=live).

You can follow along with the process in the Compat 2021 dashboard to see how
each major browser engine is doing in the five areas:

<iframe src="https://wpt.fyi/compat2021?embedded"
frameborder="0" style="height: 1000px; width: 100%;"></iframe>

The dashboard and all related bugs are listed at
[wpt.fyi/compat2021](https://wpt.fyi/compat2021).

### The five top compat focus areas in 2021

Here are the areas which are committed to being fixed in 2021, and they are
outlined in more detail in [Compat2021: Eliminating five top
compatibility pain points on the web](/compat2021).

+   CSS Flexbox
+   CSS Grid
+   CSS `position: sticky`
+   CSS `aspect-ratio` property
+   CSS transforms

### Contributing and following along

Follow any updates on [@ChromiumDev](https://twitter.com/ChromiumDev) or through
the [Compat 2021 public mailing list](https://groups.google.com/g/compat2021).
Make sure bugs exist, or [file them](/how-to-file-a-good-bug/)
for issues you have been experiencing, and if there's anything missing, reach
out through the above channels.

## Testing on the web

In both
[MDN DNA 2019](https://insights.developer.mozilla.org/reports/mdn-web-developer-needs-assessment-2019.html)
and
[2020](https://insights.developer.mozilla.org/reports/mdn-web-developer-needs-assessment-2020.html),
testing across browsers stood out among the top pain points. To understand this
area better, we're collaborating with MDN on further research. The results of
this will be published on
[https://insights.developer.mozilla.org/](https://insights.developer.mozilla.org/)
at the end of March 2021.

We're already working together with all browser vendors on [WebDriver
BiDi](https://w3c.github.io/webdriver-bidi/), a new protocol for browser
automation, and on using WebDriver BiDi in
[Puppeteer](https://github.com/puppeteer/puppeteer). This will allow Puppeteer
to support more browsers on more platforms, and will enable other popular test
and automation tools to do the same. We believe this is a crucial first step to
making it easier to test all browsers you need to support. To follow and
contribute to this work, consider joining the [Browser Testing and Tools Working
Group](https://www.w3.org/testing/browser/).

## Follow this space!

We will continually update this page to share more efforts and work as they are
underway!
