---
layout: text
title: Google Community Guidelines and Anti-Harassment Policy for In-Person and Virtual Events
description: Community Guidelines
noindex: true
---

Google is dedicated to providing a harassment-free and inclusive event experience for everyone regardless of gender identity and expression, sexual orientation, disabilities, neurodiversity, physical appearance, body size, ethnicity, nationality, race, age, religion, or other protected category. We do not tolerate harassment of event participants in any form. Google takes violations of our policy seriously and will respond appropriately.

All participants of Google events, including in-person and online attendees, event staff, speakers, and Googlers, must abide by the following policy:

## Be respectful to each other

Treat everyone with respect. Participate while acknowledging that everyone deserves to be here—and each of us has the right to enjoy our experience without fear of harassment, discrimination, or condescension, whether blatant or via micro-aggressions. All forms of communication should not demean others. Consider what you are saying and how it would feel if it were said to you, or about you.

## Speak up if you see or hear something

Harassment is not tolerated, and you are empowered to politely engage when you or others are disrespected. The person making you feel uncomfortable may not be aware of what they are doing, and politely bringing their behavior to their attention is encouraged.

We have a **ZERO TOLERANCE POLICY** for in-person or online harassment of any kind, including but not limited to:

* Stalking/following
* Deliberate intimidation
* Harassing photography or recording
* Sustained disruption of talks or other events
* Offensive verbal language
* Verbal language that reinforces social structures of domination
* Sexual imagery and language in public spaces
* Inappropriate physical contact
* Unwelcome sexual or physical attention
* Physical or cyber threats

**In relation to, but not limited to:**

* Neurodiversity
* Race
* Color
* National origin
* Gender identity
* Gender expression
* Sexual orientation
* Age
* Body size
* Disabilities
* Appearance
* Religion
* Pregnancy
* Military status
* Social demographic

Participants asked to stop any harassing behavior are expected to comply immediately. Our zero tolerance policy means that we will look into and review every allegation of violation of our Event Community Guidelines and Anti-Harassment Policy and respond appropriately. To report any behavior that makes you or others feel uncomfortable, [send us a note at this form](https://docs.google.com/forms/d/e/1FAIpQLSe5-4jlWukDnJu6Q_yNEZTlnx_ynYjpaKGz7pkA9IvfUq3Cqw/viewform?gxids=7628).

This policy extends to talks, forums, workshops, codelabs, social media, all attendees, partners, sponsors, volunteers, staff, etc. You catch our drift. Google reserves the right to refuse admittance to, or remove any person from, any Google hosted event (including future Google events) at any time in its sole discretion. This includes, but is not limited to, attendees behaving in a disorderly manner or failing to comply with this policy, and the terms and conditions herein. If a participant engages in harassing or uncomfortable behavior, the conference organizers may take any action they deem appropriate, including warning or expelling the offender from the conference with no refund or blocking the offender's account from participating online.
