---
title: web.dev at I/O 2019
subhead: New look. New docs. New blog!
date: 2019-05-04
hero: image/admin/fQkZjpeFbi9CZ9xHlsdu.jpg
alt: A group of colorful hot air balloons launching into the sky.
description: |
  For Google I/O 2019, the folks on the web.dev team have shipped a number of
  updates including a refreshed design, more Lighthouse docs, and a brand
  new blog.
tags:
  - blog # blog is a required tag for the article to show up in the blog.
---

With I/O right around the corner, we wanted to sneak out a quick update to let
you know what we've been working on since our beta launch at Chrome Dev Summit.

## New look

We want web.dev to be a best-in-class reading experience—something that folks
look forward to opening on their phones, tablets, and desktops.

In this iteration, we launched a new design with improved typography and a bit
more visual punch. We have a number of UI features still in the backlog that we
plan to ship in the coming months, but we hope you like this new visual style 💅

## Improved Lighthouse support

<figure data-float="right">
  {% Img src="image/jxu1OdD7LKOGIDU7jURMpSH2lyK2/wpGZrgY08B0x6jbLnWPU.svg", alt="Lighthouse performance cover", width="330", height="220" %}
</figure>

In the Learn section, we've rolled out
[new Lighthouse audit docs](/learn#lighthouse) with updated
images, scoring explainers, and links to guides which dive deeper into specific
topics.

We've also connected these docs to [our measure tool](/measure) so when you
audit your site you should have a better understanding of what each result
means and how to fix it.

## New blog!

Last, but not least, we have our new blog.

Not that long ago, our team used to produce a site called
[HTML5Rocks](https://www.html5rocks.com). HTML5Rocks always felt like a group of
folks coming together to share their collective excitement about what was
possible on the web.

<figure data-float="right">
  {% Img src="image/admin/4CTdRl9npyxrlqZHxbdJ.png", alt="The HTML5Rocks logo.", width="280", height="280" %}
</figure>

As we've been building web.dev, we've often said that we want to bring back some
of that "HTML5Rocks magic ✨". Get people excited about what's possible, and use
new services like [Glitch](https://glitch.com) to let them remix and play with
running code. So for the web.dev blog, we're making it our mission to keep
things open, experimental, and fun 👩‍🔬

## Wrapping up

If you want to stay up to date with the latest on web.dev, you can click that
little subscribe button in the bottom-right corner to join our newsletter, or
add the site to your feed reader of choice.

We're really excited for this year's I/O, so definitely check back in the days
and weeks ahead as we roll out new content. There's a boatload of stuff coming
and we can't wait to share it with you.

Thanks! 👋

_- The web.dev crew_
