---
layout: post
title: The Washington Post
date: 2016-07-20
updated: 2016-07-20
tags:
  - blog
  - case-study

---

<figure>
{% Img src="image/T4FyVKpzu4WKF1kBNvXepbi08t52/rTadjNpxkUGJHDs5t0MU.gif", alt="Washington Post detail", width="559", height="1000" %}
</figure>

### Summary

AMP helps the Washington Post increase returning users from mobile search by 23%

### Results

- 23% increase in mobile search users who return within 7 days
- 88% improvement in load time for AMP content versus traditional mobile web
- 1000+ articles The Washington Post publishes in AMP HTML daily

[Download PDF Case study](https://storage.googleapis.com/web-dev-uploads/file/T4FyVKpzu4WKF1kBNvXepbi08t52/214iT7lHCYfvPxJ6a8ds.pdf)

## Using AMP

With nearly 55% of their traffic coming from mobile devices, The Washington
Post knows that providing a great reading experience on mobile devices is
critical to their long-term success.

In particular, The Post is focused on making their mobile content load as quickly
as possible, because data shows that people abandon websites after just three
seconds if the content doesn’t load quickly.

In June 2015, The Washington Post joined a group of publishers and technology
companies to create the [Accelerated Mobile
Pages Project](https://www.ampproject.org/), a new open standard for publishing content which loads
instantly, anywhere across the mobile web.

> We are committed to improving speed across the board,” said David Merrell,
Senior Product Manager at The Washington Post. “If our site takes a long time
to load, it doesn’t matter how great our journalism is, some people will leave
the page before they see what’s there.”

The Post publishes over 1,000 articles in AMP every day, and they’re already
seeing concrete benefits. “We have seen load times average 400 milliseconds,
an 88% improvement over our traditional mobile website. This has made
readers more likely to tap on Washington Post stories because they know
our articles will load consistently fast.”

AMP has been great for retention as well. Traditionally 51% of mobile search
users return to The Washington Post within 7 days. For users who read stories
published in AMP, this number jumps to 63%.

> Getting started with AMP was easy because it is built on existing web
technologies. And since AMP is not a template based system, we were able
to host our content, style it as we see fit, and easily integrate our existing
advertising, analytics and other business tools,” Merrell said.
