---
layout: post
title: 'The UI fund'
authors: 
  - nsull
hero: image/kheDArv5csY6rvQUJDbWRscckLr1/Shi0nSvYtbZLu9s4jSDW.png
alt: 'Designcember'
thumbnail: image/kheDArv5csY6rvQUJDbWRscckLr1/QfroGbNObyuqpqGeza5z.png
subhead: >
  Announcing the UI fund from Chrome, designed to provide grants for people who work on design tools, CSS, and HTML.
description: >
  Announcing the UI fund from Chrome, designed to provide grants for people who work on design tools, CSS, and HTML.
date: 2021-12-06
tags:
  - blog
  - css
---

Chrome has launched a fund to support the UI ecosystem. We designed this fund to provide grants to people who work on design tools, CSS, and HTML.

All of us who work on the web regularly benefit from the work of people who create specifications, tools, demos, tutorials, and polyfills. Many of these resources are side projects, made available and supported free of charge. They exist because someone saw a need, created something to meet it, then shared it with the rest of the ecosystem.

We want to recognize and help support this work and invest in the CSS ecosystem. We're excited to enable people to spend time on these projects and create more value for the web.

## What type of projects can apply?

The following ideas are examples of the types of projects that would be a candidate for this fund. However, we are keen to hear your ideas.

### Open UI work

Design research projects, for example researching the date range component or another component you care about, in order to create a [new proposal](https://open-ui.org/proposal-guide).

### Specification writers

We are keen to help more people become involved in writing specifications. In addition to funding we can help you to make the right contacts and work with experienced specification editors.

### Accessibility work and research

Work on Open UI and new CSS layout techniques are raising accessibility issues that need research and testing before they can be resolved. For example, researching the impact of a pattern such as toggle.

We'd be interested in projects that involved the accessibility community in ensuring that new proposals are underpinned by solid research with real users.

### Polyfills, tools, and demos

Are you working on a polyfill that will enable the use of an API across more browsers? Are you involved in tooling such as Sass and PostCSS? Do you have an idea for an advanced demo that would clearly show the possibilities of some newer or experimental APIs? How about a plugin for Figma? All of these things and more could be a great candidate for a grant.

### Solving problems in key areas

There are a number of key places where developers struggle to realize their UI goals. Some of these are:

- Scrolling
- Form elements
- Toggle
- Mobile layout and UI elements
- Layout in general-for example regions

Projects around these key areas would be of interest. The shape of that project is up to you. It could be a pure research project, design ideas, specification development. We can provide funding and also connections for people with solid ideas in these spaces.

## Who can apply?

You need an Open Collective account. You can apply for a project you own or nominate a project that you think deserves support. If you don't own the project, you'll need a thumbs up from one of the core maintainers that they would accept a change such as the one you are proposing. 

## How will the submissions be judged?

The project is owned by [Sarah Drasner](http://twitter.com/sarah_edo) and [Nicole Sullivan](http://twitter.com/stubbornella), in order to make decisions on the suitability of a project they will work with specialists in that area to assess the idea. They will be assessing ideas based on the potential impact of the work. Therefore, when making your proposal demonstrate how it will have an impact on standards, tooling, design, or accessibility. 

## How do I apply?

This is a rolling fund, therefore there is no deadline for submissions. 

Create a GitHub issue or document describing the project, if one doesn't already exist. If your proposal is an addition to an existing project, then an issue will allow you to demonstrate interest from the core maintainers.

For new ideas and research proposals, create a document that explains the project, your interest and experience in the area, and the impact that you believe this project can have on the CSS ecosystem.

[Complete the form](https://forms.gle/7knaw5FvFtGVEthV7) to make your initial application.

After applying we'll be in touch, perhaps initially to discuss the idea and find out more before making a decision. We are so excited to read your ideas, and to help you be a part of improving the CSS ecosystem.

_Image credit [#WOCinTech](https://wocintechchat.com)._
