---
layout: post
title: How RebelMouse grew loyalty and engagement by optimizing Core Web Vitals
subhead: |
  A case study measuring the full impact and benefits of high performance scores on Core Web Vitals.
description: |
  A case study measuring the full impact and benefits of high performance scores on Core Web Vitals.
authors:
  - andreabreanna
date: 2022-04-15
updated: 2022-04-20
alt: The RebelMouse mascot set against a blue backdrop. The mascot is a grey mouse with a red kerchief on its head, and is standing in front of a pride flag.
hero: image/jL3OLOhcWUQDnR4XjewLBx4e3PC3/Y0KflFCo0GclHd9JK8iE.png
thumbnail: image/jL3OLOhcWUQDnR4XjewLBx4e3PC3/PVMV1zKjJs4MsJRFIzJs.png
tags:
  - blog
  - web-vitals
  - case-study
---

[RebelMouse is a cloud-based CMS](https://www.rebelmouse.com?utm_medium=post&utm_source=google&utm_campaign=cwv%20co-marketing&utm_content=home%20page) with the data-driven tools and creative strategy publishers need to provide the best experience possible for audiences, both new and old. We power high-traffic web properties for media companies like Upworthy, Narcity, Raw Story, Brit + Co, and The Independent, as well as high-value sites like Penske Trucks, Vault12, Gaingels, and many others.

Our platform reaches over 100 million people monthly in the U.S. alone. The company was founded on the belief that the open web needs to perform at the highest levels of consumer expectations to thrive, and the standards set by Google's Core Web Vitals align with this user-first vision.

For more than a decade, our global team has been engineering a CMS that creates positive and intuitive user experiences that translate into meaningful business. Core Web Vitals are a benchmark that ensure this symbiotic loop continues across every new site we power.

## Why prioritizing performance means better business

Many publishers doubt whether excellent scores on Core Web Vitals are worth the effort. They also worry that even a quality user experience won't deliver the boost in readership they need. Fortunately, our prioritization of performance at RebelMouse has given us the data to prove that Core Web Vitals are an excellent way to generate new traffic and build the user loyalty needed to have a successful business.

In order to illustrate this, we analyzed the audience behavior of a number of sites we power, both before and after we optimized for high performance scores on Core Web Vitals. In particular, we defined types of users to separate the audiences into the following key categories:

- **New Visitors:** Users who visited a site for the first time.
- **Returning Visitors:** Users who had at least two sessions.
- **Loyal Visitors:** Users who had at least three sessions or more.
- **Fans:** Users who had at least four sessions or more.
- **Superfans:** Users who had at least five sessions or more.

**References:**
- [https://www.hotjar.com/google-analytics/glossary/users](https://www.hotjar.com/google-analytics/glossary/users)
- [https://databox.com/new-vs-returning-visitors](https://databox.com/new-vs-returning-visitors)

The data from the field, gathered by Google Analytics, was overwhelmingly clear. When focusing on loyal visitors, fans, and superfans categories, we found that users are far more likely to stay longer, consume more content, and return more often on sites that receive excellent marks on their Core Web Vitals. Here's a look at some prominent examples:

<div class="table-wrapper scrollbar">
  <table>
    <thead>
      <tr>
        <th aria-hidden></th>
        <th colspan="2">
          <strong>Loyal Visitors</strong><br>
          (3 or More Sessions/User)
        </th>
        <th colspan="2">
          <strong>Fans</strong><br>
          (4 or More Sessions/User)
        </th>
        <th colspan="2">
          <strong>Superfans</strong><br>
          (5 or More Sessions/User)
        </th>
      </tr>
      <tr>
        <th><strong>Website</strong></th>
        <th><strong>Pages/User</strong></th>
        <th><strong>Time/User</strong></th>
        <th><strong>Pages/User</strong></th>
        <th><strong>Time/User</strong></th>
        <th><strong>Pages/User</strong></th>
        <th><strong>Time/User</strong></th>
      </tr>
    </thead>
    <tbody>
      <tr>
        <td>Brit + Co</td>
        <td>+1.9%</td>
        <td>+2.6%</td>
        <td>+6.6%</td>
        <td>+7.2%</td>
        <td>+6.3%</td>
        <td>+7.8%</td>
      </tr>
      <tr>
        <td>Hamu és Gyémánt</td>
        <td>+10.6%</td>
        <td>+48.2%</td>
        <td>+13.1%</td>
        <td>+47.2%</td>
        <td>+6.9%</td>
        <td>+35.3%</td>
      </tr>
      <tr>
        <td>Knocksense</td>
        <td>+37.5%</td>
        <td>+52.8%</td>
        <td>+46.9%</td>
        <td>+64.4%</td>
        <td>+47.0%</td>
        <td>+64.6%</td>
      </tr>
      <tr>
        <td>Upworthy</td>
        <td>+117.6%</td>
        <td>+50.0%</td>
        <td>+117.1%</td>
        <td>+50.8%</td>
        <td>+114.2%</td>
        <td>+49.2%</td>
      </tr>
    </tbody>
  </table>
</div>

But content consumption and time spent per user weren't the only metrics to spike. The number of users visiting and pages accessed also increased among the same categories:

<div class="table-wrapper scrollbar">
  <table>
    <thead>
      <tr>
        <th aria-hidden></th>
        <th colspan="2">
          <strong>Loyal Visitors</strong><br>
          (3 or More Sessions/User)
        </th>
        <th colspan="2">
          <strong>Fans</strong><br>
          (4 or More Sessions/User)
        </th>
        <th colspan="2">
          <strong>Superfans</strong><br>
          (5 or More Sessions/User)
        </th>
      </tr>
      <tr>
        <th><strong>Website</strong></th>
        <th><strong>Users</strong></th>
        <th><strong>Pageviews</strong></th>
        <th><strong>Users</strong></th>
        <th><strong>Pageviews</strong></th>
        <th><strong>Users</strong></th>
        <th><strong>Pageviews</strong></th>
      </tr>
    </thead>
    <tbody>
      <tr>
        <td>AméricaEconomía</td>
        <td>+16.0%</td>
        <td>+10.4%</td>
        <td>+11.8%</td>
        <td>+6.8%</td>
        <td>+6.9%</td>
        <td>+4.6%</td>
      </tr>
      <tr>
        <td>EHN</td>
        <td>+24.2%</td>
        <td>+13.8%</td>
        <td>+24.9%</td>
        <td>+13.4%</td>
        <td>+24.0%</td>
        <td>+9.0%</td>
      </tr>
      <tr>
        <td>PAPER Magazine</td>
        <td>+24.7%</td>
        <td>+20.0%</td>
        <td>+39.7%</td>
        <td>+32.1%</td>
        <td>+55.7%</td>
        <td>+35.7%</td>
      </tr>
      <tr>
        <td>Second Nexus</td>
        <td>+16.8%</td>
        <td>+14.2%</td>
        <td>+15.0%</td>
        <td>+13.4%</td>
        <td>+15.7%</td>
        <td>+13.3%</td>
      </tr>
    </tbody>
  </table>
</div>

## From normal to high-performing: How RebelMouse transforms websites

The good news is that performing well on Core Web Vitals is possible with thoughtful, strategic changes made to your site's codebase. Here are a few ways RebelMouse powers high-performing websites:

### Progressive web app

RebelMouse optimizes all third-party calls in a progressive web app that delivers the most important content first, and then sequences the rest of the calls as the reader needs to see them.

We have [a method that loads JavaScript](https://www.rebelmouse.com/new-javascript-element-in-layout-design-tool?utm_medium=post&utm_source=google&utm_campaign=cwv%20co-marketing&utm_content=javascript%20element) immediately after the Largest Contentful Paint (LCP) event has completed. We give our users the option to load JavaScript through three different priority levels:

- **Optimized** is best for users who want the latest cutting-edge approaches. We use it in our own development work. This priority level will pause JavaScript from firing until well after the page has fully loaded, which gives you the highest performance.
- **Load Blocking** is used for executing JavaScript right away, and will generally have a negative impact on your performance scores. This priority level will fire the JavaScript immediately after the page has completed loading. This has the potential to drop your performance scores by 10–40 points depending on the extra call.
- **Post LCP** is the best option to blend great performance scores with a very fast load. This priority level will cause JavaScript to load immediately after the Largest Contentful Paint event has completed. (This is recommended for ads only, where you have increased revenue in delivering ads to users who are only on the page for five seconds or so.)

### Optimize social embeds

To protect Cumulative Layout Shift (CLS) and LCP scores, all social embeds need to be set to lazy load.

For CLS preservation, you have to dynamically find the size of the embed with server-side technology, and insert it into your own storage of the properties of that embed. Then, the embed needs to be delivered to your front end to prevent the layout from shifting upon load. For those with interest in deeper dives on this topic, we have posts specifically on [Twitter](https://www.rebelmouse.com/optimized-twitter-embeds?utm_medium=post&utm_source=google&utm_campaign=cwv%20co-marketing&utm_content=optimized%20twitter%20embeds) and [TikTok](https://www.rebelmouse.com/how-to-embed-a-tiktok?utm_medium=post&utm_source=google&utm_campaign=cwv%20co-marketing&utm_content=tiktok%20embed) examples with more details.

### Ultra-light, smart HTML and CSS

Site HTML and CSS has to be constructed in a way that allows for the delivery of above-the-fold images and text to preload before the rest of the page.

- Bad HTML constructs will force the browser to process many unnecessary site elements that are below the fold in order to render what is above the fold in the first viewport.
- We have more in-depth articles on how we achieve this on RebelMouse here:
  - A breakdown on [how to improve Core Web Vitals](https://www.rebelmouse.com/pagespeed-score?utm_medium=post&utm_source=google&utm_campaign=cwv%20co-marketing&utm_content=pagespeed%20score).
  - [A full guide](https://www.rebelmouse.com/how-to-improve-core-web-vitals?utm_medium=post&utm_source=google&utm_campaign=cwv%20co-marketing&utm_content=how%20to%20improve%20core%20web%20vitals) on implementing fast page speeds while also including third-party scripts.
  - An in-depth guide on [optimizing for LCP](https://www.rebelmouse.com/core-web-vitals-2021?utm_medium=post&utm_source=google&utm_campaign=cwv%20co-marketing&utm_content=core%20web%20vitals%202021).

## Publish with a performance-first mindset

Since the rollout of Core Web Vitals, developers have felt the impact of how their publishing platforms stack up against [Google's recommended thresholds](/defining-core-web-vitals-thresholds/).

[HTTP Archive](https://httparchive.org), an open-source project that identifies trends and records historical patterns across millions of URLs, has revealed how top content management systems perform against Google's page experience standards in its [Core Web Vitals Technology Report](https://datastudio.google.com/u/0/reporting/55bc8fad-44c2-4280-aa0b-5f3f0cd3d2be/page/M6ZPC). RebelMouse has [consistently outperformed](https://datastudio.google.com/u/0/reporting/55bc8fad-44c2-4280-aa0b-5f3f0cd3d2be/page/M6ZPC?params=%7B%22df44%22:%22include%25EE%2580%25800%25EE%2580%2580IN%25EE%2580%2580ALL%25EE%2580%2580WordPress%25EE%2580%2580Drupal%25EE%2580%2580Wix%25EE%2580%2580Squarespace%25EE%2580%2580Adobe%2520Experience%2520Manager%25EE%2580%2580Contentful%25EE%2580%2580Sitecore%25EE%2580%2580Arc%2520Publishing%25EE%2580%2580Chorus%25EE%2580%2580RebelMouse%22,%22df46%22:%22include%25EE%2580%25800%25EE%2580%2580IN%25EE%2580%2580mobile%22%7D) major CMS platforms on Google's most critical metrics since its rollout and into 2022:

<figure>
  {% Img src="image/jL3OLOhcWUQDnR4XjewLBx4e3PC3/3eY8EMxr0uDCD25NvJj9.png", alt="A comparison of origins having good Core Web Vitals across platforms. The platforms are RebelMouse, WordPress, Drupal, Wix, Squarespace, Adobe Experience Manager, Contentful, Sitecore, Arc Publishing, and Chorus. The time period is from January 1, 2021 to January 31, 2022 for mobile devices. The trend shows that RebelMouse outperforms all other CMS platforms on Core Web Vitals, and this trend increases over time.", width="800", height="452" %}
</figure>

## Performance without compromise

Creating quality content is now only half the battle for publishers and brands alike. Quality content must be supported by modern technology that can keep up with the speed and standards of today's web. We're able to deliver Core Web Vitals that make the grade because site performance isn't just a goal, it's a company pillar that's woven into our culture. We use our intense focus on performance to help our clients make the most of the open web by growing traffic and building revenue without sacrificing user experience.

If you'd like to learn more about how we can help your site exceed the industry standard on Core Web Vitals, [click here to learn more about RebelMouse today](https://www.rebelmouse.com/st/Request_a_Demo?utm_medium=post&utm_source=google&utm_campaign=cwv%20co-marketing&utm_content=request%20a%20demo).
