---
title: How do I notify users that my PWA is installable?
subhead: How to promote installation of Progressive Web Apps and best practices.
authors:
  - petelepage
date: 2019-06-04
updated: 2019-06-04
description: |
  How to promote installation of Progressive Web Apps and best practices.
tags:
  - blog # blog is a required tag for the article to show up in the blog.
---

If your PWA has use cases where it’s helpful for a user to install your app,
for example if you have users who use your app more than once a week, you
should be promoting the installation of your PWA within the web UI of your app.

<figure>
{% Img src="image/T4FyVKpzu4WKF1kBNvXepbi08t52/0Nl5R8kgpRnaFI4i1l95.png", alt="In-feed promo banner screenshot", width="800", height="1000", class="screenshot" %}
</figure>

**But how should you notify the user that your PWA can be installed?**

Check out [Patterns for Promoting PWA Installation][patterns-mobile], a series
of recommended patterns and best practices that you can use to promote the
installation of your Progressive Web App.

It includes patterns for notifying users within the core UI of your app,
within your app's content, or just letting the browser notify the user. And,
it includes recommendations on how to place the notification for different
types of apps.

[patterns-mobile]: https://developers.google.com/web/fundamentals/app-install-banners/promoting-install-mobile
