---
layout: post
title: OLX boosts re-engagement on the mobile web by 250% with a Progressive Web App
description: | 
    For OLX, creating a Progressive Web App increased engagement by 250% and reduced page time to interactive by 23%
date: 2017-05-17
updated: 2017-05-17
tags:
  - blog
  - case-study

---

<figure>
{% Img src="image/T4FyVKpzu4WKF1kBNvXepbi08t52/s13PUoEsXkodTR5hz1YP.jpg", alt="OLX detail", width="800", height="800" %}
</figure>
 
One of the largest online destinations for classified ads in India, OLX provides
communities in high-growth markets with vibrant online marketplaces. They
connect local people so they can buy, sell, or exchange used goods and services,
making it fast and easy for anyone to post a listing on the web.

- 23% less time until page is interactive
- 80% lower bounce rates
- 146% higher CTR on Ads
- 250% more re-engagement

## Challenge

With declining desktop growth, OLX gets over 90% of their traffic from mobile
devices—and this number is still growing. Half of their visitors come via their
native app and half via the mobile website. OLX noticed, however, that the
majority of conversions were still happening on the native app. Their mobile-web
bounce rates tended to be higher as well.
 
OLX analyzed behavior on their mobile site and realized their mobile web
experience was too slow. Monetization also suffered from slow-loading ads. OLX
aggressively doubled down on acquiring quality users and growing their engaged
user base on the mobile web. They looked to Progressive Web App (PWA)
technologies to provide a faster-loading, immersive and app-like experience.
 
## Solution

OLX wanted to re-engage mobile web users, just as they would their mobile app
users. On Android devices (which all support service worker, a key PWA
technology), this meant taking advantage of re-engagement capabilities like push
notifications and the “Add to Home screen” prompt.
 
With push notifications, OLX sends context-based alerts to tell users they have
messages from buyers or sellers. These notifications look the same as those on
native apps, and arrive even if the browser is no longer running. Over 600,000
users have signed up for notifications since the site launched in November 2016.
 
Altogether, these two updates increased engagement by 250%.
 
Creating a PWA improved other metrics too: the time until the page became
interactive fell by 23%, with a corresponding 80% drop in bounce rates.
Monetization also improved, with ads loading faster, the clickthrough rate (CTR)
rising 146%. Their best-in-class PWA achieved a performance score of 92/100 on
Lighthouse, an automated tool for improving web-page quality.
 
{% Blockquote 'Amarjit Batra, CEO,OLX India' %}
In 2016 we re-invented classifieds mobile experience with the release of the new
OLX App and its PWA. Building a new platform, we leveraged innovative technology
and deep consumer understanding to roll out improved and forward-looking product
changes that make the online classifieds experience safer, simpler, and social.
Mobile being the first screen to ​ the​ internet for millions of users in India,
we wanted to ensure that not only app-savvy users but people comfortable in
using mobile websites can feel the same experience while using OLX. The PWA
version feels like a natural app on the device, with an immersive user
experience.
{% endBlockquote %}
 
 
 
 
 
