---
layout: post
title: Ola drives mobility for a billion Indians with Progressive Web App 
date: 2017-05-17
updated: 2017-05-17
tags:
  - blog
  - case-study

---

<figure>
{% Img src="image/T4FyVKpzu4WKF1kBNvXepbi08t52/qjCVAu4foDvaKnBHcX05.jpg", alt="Ola detail", width="800", height="800" %}
</figure>

Ola is the leading cab aggregator in India, with a relentless mission to drive
mobility for a billion Indians. The company reaches over 100 Indian cities with
a network of about 600K driver-partners. As one of India’s most highly valued
startups, Ola completes more than a million daily rides, fighting for the lion’s
share of the country’s estimated 300 million daily taxi trips.

- 68% increase in mobile traffic in Tier 2 and 3 cities 
- In Tier 2 cities conversion rates are same as native app. In Tier 3 
  cities, conversion rates are 30% higher with the PWA.
- PWA application size is 200KB, which is 300x smaller than downloading an
  Android app and more than 500x smaller than the iOS app
- 20% of users who book in their PWA had prev. uninstalled their app


## Challenges

Tier 2 and Tier 3 cities (cities with populations of 20,000 to 99,000) pose
unique challenges and opportunities for Ola. Demand for sustainable, reliable
transport services is growing rapidly and is eagerly anticipated in these areas.
People in these cities often deal with intermittent cellular connectivity and
have low-end smartphones with low memory and slow processors. These users are
less apt to download and store native apps on their smartphones because native
apps require high data usage and take up a lot of space —the Ola Android app is
a 60MB download and the iOS app is 100M.  It was clear that Ola needed a
different way to reach these users.
 
The mobile web presented a perfect solution. It offers easy discovery and low
friction—users just click a link instead of downloading an app. Other advantages
include push notifications, and the “Add to Home screen“ user prompt. As Dipika
Kapadia, Ola’s head of consumer web products notes, “Apps have many advantages
but must be developed for different operating systems, while a single site is
good for any browser.”
 
## Solution

Ola built their mobile website as a Progressive Web App (PWA). Using just 200KB
of data to install, the PWA is at least 300X smaller than downloading the
Android app and 500X smaller than downloading their iOS app. Repeat visits use
as little as 10KB. This low data consumption translates into a 3.4-second first
visit and less than a second for repeat visits on 2G and 3G networks—an ideal
solution for millions of Indians.
 
Ola also noticed that 20% of users who book using their PWA had previously
uninstalled their app. By reducing the amount of storage space needed, the PWA
allowed them to effectively re-engage with their previous app users.
 
{% Blockquote 'Dipika Kapadia, head of consumer web & corporate products, Ola' %}
Having a fast, engaging mobile website means we’re no longer turning
away potential users who don’t want to use data or space to download an
app.
{% endBlockquote %} 

The PWA is helping Ola reach a broader set of users in new cities. They’ve seen
mobile traffic from Tier 2 and Tier 3 cities grow by 68%. Since launch,
conversion rates on the PWA have been the same as their native app in Tier 2
cities, and for Tier 3 cities, conversion rates are 30% higher on the PWA. 
 
## A future without apps?

Well, not exactly. For Ola, having both a native app and a PWA just makes sense.
By skipping the requirement that users install an app, Ola believes their PWA is
tailor-made for the low-end devices. Users can now use either depending on their
location and bandwidth.
 
{% Blockquote 'Ankit Bhati, Co-Founder & CTO, Ola' %}
There’s no need to choose between the web and the app. Today, we believe
Ola is set for its next stage of growth. We intend to balance the two and
have both strategies in play.
{% endBlockquote %} 
