---
layout: post
title: New Progressive Web App training now available
subhead: Get started with Progressive Web Apps with our new six-part training, complete with new codelabs.
authors:
  - samrichard
description: A new, six part Progressive Web App training is now available, complete with a new series of codelabs to teach you how to build reliable, installable, and capable PWAs.
date: 2021-05-20
updated: 2022-04-22
tags:
  - blog
  - progressive-web-apps
---

{% Aside %}
The training described below is designed as material to teach to others in a workshop format. For a self-guided course check out [Learn PWA](/learn/pwa/). This course is based on the below material, but designed for individuals to work through rather than a course to teach others.
{% endAside %}

A lot has changed in the world of [Progressive Web Apps](/progressive-web-apps/) since we released our last set of PWA training over four years ago: CSS Grid achieved widespread implementation, PWAs came to desktops, and the [capabilities project](https://developer.chrome.com/blog/fugu-status/) has launched more than 25 new device-integration focused APIs, opening up brand new app segments that can be built entirely on the web. Today, we're excited to share the first iteration of our newly updated PWA training to teach you how to build reliable, installable, and capable Progressive Web Apps for all devices.

The current version of the training is divided into six slide decks, ready for you to learn from or for you to pick up and teach to others. They are:

- [Introduction to Progressive Web Apps](https://docs.google.com/presentation/d/1w0BVEmtCQvmJGHK0OjOhr8HeNVGYi0ezGz81fimkDdE/edit?usp=sharing)
- [Creating a Solid Foundation for your PWA](https://docs.google.com/presentation/d/1tJH05P8OfcDgUjNbW-oxZN9G-OtmDpA-lqNMy1M97Cs/edit?usp=sharing&resourcekey=0-UAAWbPgLxyrTBkqSSOj6GQ)
- [Improve the Reliability of your Web App](https://docs.google.com/presentation/d/1CwKVRauMW30SrHTgexnJQw2XBOZt_R6K6_NucmTkygY/edit#slide=id.p)
- [Make your Web App Installable](https://docs.google.com/presentation/d/1TBCK2b_yVov-DwHpRf8vWyEz2KqIu-gg8h-QOyss7HI/edit?resourcekey=0-GTzLs6UHZyQZ-tBG6LlOMQ)
- [Adding Advanced Capabilities to your Web App](https://docs.google.com/presentation/d/1m7U2iK-63aaTvMQGDwxtLgqWLg8RwH4Ba2AwFuTcxOo/edit)
- [Adopting Advanced Web App Architectures](https://docs.google.com/presentation/d/13KHsxknXSbADS1kRLYkS46YJr_AsImoW6r6VAjYj3dE/edit?resourcekey=0-MrN8aV43XaOE_FM18Vsn_Q#slide=id.p)

To go along with this new material, there are eight new codelabs that will guide you through turning a web app into a Progressive Web App with deep device integration, using the concepts taught throughout the slide decks. You can jump into any codelab and work on it individually, or you can go through them one after another; the choice is yours. They are:

- [Going Offline](https://developers.google.com/codelabs/pwa-training/pwa03--going-offline#0) - Basics of writing a service worker to cache and serve content offline
- [Working with Workbox](https://developers.google.com/codelabs/pwa-training/pwa03--working-with-workbox) - Using [Workbox](https://developer.chrome.com/docs/workbox/) to write your service worker
- [IndexedDB](https://developers.google.com/codelabs/pwa-training/pwa03--indexeddb) - Using IndexedDB to store and retrieve data
- [Tab to Taskbar](https://developers.google.com/codelabs/pwa-training/pwa04--tab-to-taskbar) - Making your web app installable and providing app shortcuts
- [Prompting and Measuring Install](https://developers.google.com/codelabs/pwa-training/pwa04--prompt-measure-install#5) - Adding in-app install prompts, and where to put success tracking
- [Empowering your PWA](https://developers.google.com/codelabs/pwa-training/pwa05--empowering-your-pwa#0) - Adding advanced capabilities, including accessing the local file system and registering as a file handler
- [Service Worker Includes](https://developers.google.com/codelabs/pwa-training/pwa06--service-worker-includes#0) - Dynamically generating a streaming service worker response
- [Working with Workers](https://developers.google.com/codelabs/pwa-training/pwa06--working-with-workers#0) - Using web workers to offload work from the main thread

Over the next few months, we'll be converting the slide deck content into easier-to-consume and update formats. This will make it easier for us to keep the content up-to-date, so no more waiting four years for another push of content. Keep an eye on this space. The future of web apps is exciting, and we're thrilled to teach you how to build it.
