---
layout: post
title: New patterns for media apps
subhead:
  Dive into a fantastic collection of new patterns for media apps. Grab the user's screen, add video Picture-in-Picture mode, create audio effects, record from the mic, or customize media notifications.
authors:
  - beaufortfrancois
  - conwayt
description:
  This blog post announces a new collection of patterns for media apps.
date: 2022-11-03
hero: image/vvhSqZboQoZZN9wBvoXq72wzGAf1/qeOFBnNK1TvZIJoo6MVI.jpeg
alt: Person holding mobile phone playing audio.
tags:
  - blog
  - capabilities
  - media
---

Let's welcome our new collection of [media patterns](/patterns/media) to help you create modern media experiences on the web for great audio and video playback:

1. [Use the Web Audio API to add effects to audio sources](/patterns/media/audio-effects/).
2. [Let the user control media playback on the lock screen, in a widget, or with hardware keys](/patterns/media/media-session/).
3. [Record audio from the user's microphone](/patterns/media/microphone-record/).
4. [Create a custom Picture-in-Picture button for your video player](/patterns/media/picture-in-picture/).
5. [Record the user's screen](/patterns/media/screen-record/).

We hope these patterns will help you build amazing apps, and we're looking forward to your feedback! You can provide feedback by tweeting at [@ChromiumDev](https://twitter.com/ChromiumDev) or [filing an Issue](https://github.com/GoogleChrome/web.dev/issues/new/choose).

_Photo by [Kenny Eliason](https://unsplash.com/photos/plrlb68XPqI)._
