---
layout: post
title: Mynet speeds up their mobile web experience by 4X, increasing revenue by 25% with AMP-based PWA
date: 2017-05-17
updated: 2017-05-17
tags:
  - blog
  - case-study

---

<figure>
{% Img src="image/T4FyVKpzu4WKF1kBNvXepbi08t52/9ZQhcn69EXtRZ9UHzcaT.jpg", alt="MyNet detail", width="800", height="800" %}
</figure>

Every month Mynet provides more than 34 million visitors to their site with
news, video, gaming, financial, informational and entertainment content and
services. After launching a Progressive Web App (PWA) that uses Accelerated
Mobile Pages (AMP) for content, they saw a 4X decrease in average page load
times. In addition, Mynet saw a significant increase in user engagement, with
the average time spent on their mobile site rising 43%.

- 25% higher revenue per article pageview
- 4X faster average page-load speed
- 43% longer average time on site
- 34% more page views per session
- 24% lower bounce rates
 
## Challenge

With more than 85% of their mobile traffic coming from the mobile web, Mynet’s
mobile website is an indispensable part of their strategy. However, they noticed
that users spent 2X less time on the mobile site than users of their native app.
When Mynet analyzed user behavior on their mobile site, it was clear that their
mobile-web experience was too slow. Mynet needed to build an extremely fast,
engaging mobile website, similar to what they could achieve with a native app.
 
## Solution

To drive traffic and re-engagement simultaneously, Mynet launched a PWA that
uses AMP to deliver a fast, app-like experience on the mobile web. With this
setup, article pages loaded four times faster compared to the old mobile site.
This led to a corresponding 24% decrease in bounce rates. Mynet also saw a
correlation between speed and engagement, as users began spending 43% more time
on the site. They also saw pageviews increase by 34% per session. This all was
accomplished in several stages:
 
## Starting fast with AMP

Mynet first built support for its articles, served as standalone AMP pages. This
let them show results in the AMP carousel in Google search results. It also let
them deliver outstanding page-load performance for their users browsing content
on the mobile web, which is critical on limited or flaky networks. Launching
standalone AMP pages wasn’t a big challenge with their CMS system, and it only
took two weeks to launch all of their article content in AMP.
 
To ensure that ads were served as quickly and efficiently as possible, Mynet
launched AMP Ads. These ads load up to twice as fast as standard ads, with
clickthrough rates (CTR) and revenue increasing by up to 30%.
 
## Staying fast and re-engaging with PWA

Next, Mynet wanted to improve their mobile website, so they built a separate
beta version of their mobile site with PWA technologies. They looked to these
technologies to provide a more app-like, immersive user experience (UX), instead
of minimally updating their underlying site. In particular, they took advantage
of service workers for reliable performance on flaky networks, and the user
prompt “Add to Home Screen” plus Push Notifications for re-engagement. They
created a best-in-class PWA with a Lighthouse performance score of 95/100.
(Lighthouse is an automated tool for improving the quality of web pages that can
run against any page on the web.)
 
## AMP and PWAs work better together

After testing AMP and PWAs as standalone versions and optimizing their
performance, Mynet was ready to move to the last stage of building a unified
solution for their mobile website. Putting AMP content pages inside their PWA
brought together speed and usability in their new mobile site. Once the combined
AMP/PWA site launched, Mynet reduced the number of web-production versions by
half—mobile and desktop—lowering the number of implementations required to
maintain and improve the code.
 
Why use a combined AMP/PWA solution? AMP delivers outstanding first-page load
performance on the mobile web, while PWAs make repeat visits fast and reliable.
Thanks to the “Add to Home Screen” prompt and Push Notifications, PWAs also let
sites increase their users’ re-engagement. Together, this strategy allows Mynet
to deliver high-quality experiences on first or repeat visits, regardless of the
network condition.
 
Approximately 30% of visitors to Mynet’s mobile web site use an iOS device.
Mynet saw a 15% increase in average pageviews per session and a 23% decrease in
bounce rate on iOS—all despite “Add to Home Screen”, Push Notifications, and
offline caching being unavailable due to lack of service worker support on iOS.
This increased engagement resulted from the speed and user-interface (UI)
improvements delivered by the AMP-based PWA.
 
The overall impact of using AMP within their PWA is a 25% increase in ad revenue
per article pageview.
 
{% Blockquote 'M. Fuat Seker , Business Development and Product Group Manager, Mynet'%}
With a renewed focus on speed, we decided to integrate AMP and build a
Progressive Web App. AMP was important to reduce page abandonments, and we
now see AMP pages loading four times faster. By building a PWA, we achieved
feature parity with our app and users now spend 43% more time on our site
and re-engage more often.
{% endBlockquote %}
 
 
### Additional results 

- 2X faster load times with AMP Ads
- 30% higher CTR and revenue with AMP Ads
- 15% increase in average pageviews per session on iOS
- 23% lower bounce rates in iOS
