---
title: Milliseconds make millions
subhead: >
  A 0.1 second improvement in 4 speed metrics can improve progression rates across
  the full purchase funnel.
description: >
  A 0.1 second improvement in 4 speed metrics can improve progression rates across
  the full purchase funnel.
authors:
  - olgademidova
scheduled: true
date: 2020-06-24
hero: image/admin/Ml6J6Ljjj2EjsbfSDFUt.png
alt: An illustration of a person using a phone.
tags:
  - blog
  - performance
  - case-study
  - analytics
  - metrics
  - monetization
  - mobile
---

A new study [Milliseconds Make Millions][report]
reveals the significant impact of mobile site speed on consumers' willingness to
spend money and engage with brands online. The results shows that even a 0.1
second improvement in load times can improve progression rates across the full
purchase funnel. There was also a positive impact on pageviews, conversion
rates, and average order value. The results underline that rising customer
expectations and increasing use of smartphones are amplifying the need for
mobile speed. The competitive gap will widen between brands who provide great
mobile experiences and those who don't.

{% Img src="image/tcFciHGuF3MxnTr1y5ue01OGLBn2/qPLJXSQDlGAKJXoww9ha.jpg", alt="A 0.1 second improvement of mobile site speed increases conversion rates by 8.4% for retail sites and 10.1% for travel sites.", width="800", height="391" %}

## Summary of impact by vertical

All of the improvements below were observed after a 0.1 improvement in 4
metrics: [First Meaningful Paint](https://developer.chrome.com/docs/lighthouse/performance/first-meaningful-paint/),
[Estimated Input Latency](/estimated-input-latency/), Observed
Load ([Avg. Page Load Time](https://support.google.com/analytics/answer/2383341)
in Google Analytics), and Max Server Latency ([Time To First
Byte](/ttfb/)).
Every page across the user journey had to improve each of these metrics by 0.1
seconds in order for these positive impacts to be observed.

{% Aside %}
First Meaningful Paint is now deprecated. Use [Largest Contentful
Paint](/lcp/) instead.
{% endAside %}

### Retail

With a 0.1s improvement in site speed across the measured metrics,
study participants observed an increase in progression rates (percentage of
users moving from a webpage through to the next step of a conversion funnel) on
almost every step of the mobile journey. In particular, there was an increase of
3.2% from Product Listing Page to Product Detail Page, and a 9.1% increase from
Product Details Page to Add To Basket Page. Retail consumers also spent 9.2%
more, a dramatic uplift.

{% Img src="image/tcFciHGuF3MxnTr1y5ue01OGLBn2/b34phnJ55KvnWakk9HST.jpg", alt="Detailed description of how progression rates were affected for retail sites. Homepage to Product Listing page: -0.5%. Product Listing page to Product Details page: 3.2%. Product Details page to Add To Basket page: 9.1%. Add To Basket page to Basket page: 0.1%. Basket page to Checkout page: 3.9%. Checkout to Order page: 4.7%.", width="800", height="437" %}

### Luxury

Out of all verticals studied, the impact for luxury verticals was the highest.
One should bear in mind, however, that the progression rates on luxury sites
tend to be quite small. The progression rates to Contact Us Page increased by
20.6% when the site speed metrics were improved by 0.1 seconds, and there was a
significant 40.1% increase in users moving from Product Detail Page to Add To
Basket page. Longer sessions were also recorded through the entire browsing
journey.

{% Img src="image/tcFciHGuF3MxnTr1y5ue01OGLBn2/PjGOuJLL0ez9oOFzjBxt.jpg", alt="Detailed description of how progression rates were affected for luxury sites. Homepage to Product Listing page: 4.0%. Product Listing page to Product Details page: 15.8%. Product Details page to Add To Basket: 40.", width="800", height="437" %}

### Travel

Travel sites saw a 2.2% increase in check-out completion and a 10% improvement
in booking rates.

{% Img src="image/tcFciHGuF3MxnTr1y5ue01OGLBn2/GXu5tb0A3KD1mX78vOQE.jpg", alt="Detailed description of how progression rates were affected for travel sites. Form Step 1 page to Form Step 2 page: 2.0%. Form Step 2 page to Form Submission page: 2.2%.", width="800", height="437" %}

### Lead generation

Lead generation sites also saw a positive impact across the board, with the
highest impact being a 21.6% improvement in the number of users that progressed
to the Form Submission Page. A 7% increase in page views was also recorded.

{% Img src="image/tcFciHGuF3MxnTr1y5ue01OGLBn2/agnvU71uKxg9xDcXnzlP.jpg", alt="Detailed description of how progression rates were affected for lead generation sites.  Homepage to Form Step 1 page: 5.5%. Form Step 1 page to Submission page: 21.6%.", width="800", height="437" %}

## About the study

The study was commissioned by Google and conducted by 55 and Deloitte. The aim
of the study was to determine whether mobile site speed has an impact on brand
revenue. The research team studied 37 leading European and American brand sites,
collecting data on over 30 million user sessions.
The tracking and analytics setups of each site was rigorously audited. No UX
redesigns occurred on any of the sites during the duration of the study. Mobile
load times were monitored hour-by-hour for 30 days at the end of 2019. The
results were consolidated in real-time against a range of typical
revenue-related metrics drawn from each brand's analytics tool.

For more information, read the full [Milliseconds Make Millions][report] report.

[report]: https://www2.deloitte.com/content/dam/Deloitte/ie/Documents/Consulting/Milliseconds_Make_Millions_report.pdf
