---
layout: post
title: MakeMyTrip.com’s new PWA delivers 3X improvement in conversion rates
description: |
    After launching a Progressive Web App, MakeMyTrip.com's conversion rate on the mobile web tripled, while their page-load speed improved by 38%.
date: 2017-05-17
updated: 2017-05-17
tags:
  - blog
  - case-study

---

<figure>
{% Img src="image/T4FyVKpzu4WKF1kBNvXepbi08t52/5IcEsNM1HiiLZFstLIYp.jpg", alt="Make-my-trip detail", width="800", height="800" %}
</figure>

MakeMyTrip is India's leading travel company, with nearly eight million visitors
to their site every month. Mobile has emerged as the preferred booking medium
for MakeMyTrip customers, accounting for over two-thirds of the site’s traffic.
After launching a Progressive Web App (PWA), their conversion rate on the mobile
web tripled, while their page-load speed improved by 38%.

- 3X improvement in conversion rate
- 38% improvement in page load times
- 160% increase in shopper sessions

## Challenges

With more than 23 million downloads, MakeMyTrip’s native app is indispensable,
driving half of all their bookings. But in a market of over a billion people,
many potential users only have intermittent connectivity and visit the site from
low-end phones with data limitations. These two factors make it difficult to
drive users to download a native app, leading to steep drop-off rates and high
customer acquisition costs.
 
In addition, MakeMyTrip found that their mobile website was a better way to get
new users to learn about their service. They noticed that the cost of attracting
consumers to their mobile website was substantially lower than the cost of
driving app downloads. MakeMyTrip found it difficult to build an engaging user
experience for the mobile web, however. They initially viewed it as a platform
to shift non-app users to their native app, then found that many people still
preferred to use the service on their mobile browsers.
 
MakeMyTrip also wanted to build an effective mobile presence to reach Indians
beyond the country’s top eight cities. In those farther-flung areas, users are
more likely to use low-end devices on slower 2G or 3G networks. To reach that
audience, they needed a solution that merged the benefits of native apps and the
mobile web so they could lower the cost of discovery and increase engagement
rates.
 
## Solution

The answer? They developed a PWA that led to a fast, reliable and polished
mobile-web experience. The new strategy reduced page-load times by 38%.
MakeMyTrip also tripled their conversion rates on the PWA. Along with boosting
the brand’s overall conversion rate, the PWA drove a 160% increase in shopper
sessions and lowered the bounce rate by 20%, compared with their previous mobile
site.
 
With no requirement for users to install an app, MakeMyTrip believes PWA is
tailor-made for the low-end devices that account for the majority of smartphone
sales in India. Published online, PWAs are completely linkable. And the PWA even
works offline, using cached data from earlier online activity. For MakeMyTrip,
having both a native app and a PWA just makes sense. “There is no need to choose
between the web versus the native app. We don’t want to slow growth for that,”
says Anshuman Bapna. “So we balance the two and have both strategies in play.”
 
With MakeMyTrip’s PWA, users are one click away from content. First-time
shoppers using the PWA are highly engaged and three times more likely to convert
than first-time visitors to the native app with comparable booking values.
MakeMyTrip also noticed that half the bookings on their new PWA were made at the
last minute—a stark contrast to their native app, where last-minute bookings
account for only 20% of total bookings. “When we add a PWA to our mobile mix in
a market of over a billion people, we know that we’re reaching many more
customers,” says Alok Bhageria, MakeMyTrip product manager.
 
Driving mobile traffic directly to the PWA, regardless of the operating system,
is profitable for MakeMyTrip. They have an aggressive growth strategy, and the
PWA is helping them to reach users in 24% more cities. The road ahead is
exciting, as they plan to continue focusing on new PWA technologies that will
deliver even better customer experiences and margins.
 
{% Blockquote 'Anshuman Bapna, Chief Product Officer at MakeMyTrip' %}
Having the ability to operate on any OS is non-trivial in terms of
development time and expense. Browsers that may not support all PWA features
still render content, so there is really no need to wait. For anyone living
in an area of spotty or expensive internet access, the ability to cut data
usage is a HUGE deal. We believe that Progressive Web Apps will become the
new mobile standard
{% endBlockquote %}
 

### All Stats

- 3X improvement in conversion rate
- 38% improvement in page load times
- 160% increase in shopper sessions
- 30% more last-minute shoppers
- 24% more cities with a user footprint on their new PWA
- 20% decrease in bounce rate
- First time shopper 3X more likely to convert than App 
