---
layout: post
title: All of Learn Accessibility! is available
subhead: >
  All modules have now been published.
description: >
  We launched the final modules for Learn Accessibility. This means you
  can take this course from start to finish or in any order you choose.
date: 2023-01-12
authors:
  - alexandrawhite
hero: image/VbsHyyQopiec0718rMq2kTE1hke2/47JeuiQdxypVbW87NnSB.svg
thumbnail: image/VbsHyyQopiec0718rMq2kTE1hke2/03dCg7PsCbcwblqRHYMB.png
alt: 'Learn Accessibility'
tags:
  - blog
  - accessibility
---

All modules in the [Learn Accessibility](/learn/accessibility/) course are now
available. Written by [Carie Fisher](https://twitter.com/cariefisher), these
courses take you through the essentials for building accessible websites and
web apps.

You can read them in whatever order you'd like. The final modules on testing
walk you through a culmination of all of your knowledge:

* [Automated testing](/learn/accessibility/test-automated)
* [Manual accessibility testing](/learn/accessibility/test-manual)
* [Assistive technology testing](/learn/accessibility/test-assistive-technology)

The last new module will teach you how to make your
[forms more accessible](/learn/accessibility/forms). This is a great complement
to [Learn Forms](/learn/forms/).

And that's not all. We had four community spotlights with people working on
accessibility:

* [Melanie Sumner](/community-highlight-melanie/) told us about her journey
  into engineering, accessible design, Ember.js, and the importance of funding
  these efforts.
* [Olutimilehin Olushuyi](/community-highlight-shuyi/) told us about his move
  from the law to web development, building accessible communities, and creating
  accessible layouts.
* [Albert Kim](/community-highlight-albert-kim/) told us about mental health
  awareness, building for invisible disabilities, the COGA Accessibility
  Community Group, and more practical wisdom.
* [Elisa Bandy](/community-highlight-elisa/) told us about her work for
  Google's internal documentation, how to prioritize use cases, and building
  expertise.

We hope you'll discover some new best practices. These modules are meant to
build your expertise, but some accessibility best practices differ, based on
the disability you're addressing.

We remain open to your feedback. [Open a GitHub issue](https://github.com/GoogleChrome/web.dev/issues/new/choose)
and give as much information as you can so we can address your questions or concerns.
