---
layout: post
title: Lancôme rebuilds their mobile website as a PWA, increases conversions 17%
description: |
    To drive both traffic and re-engagement, luxury cosmetics brand Lancôme launched a Progressive Web App (PWA) to deliver a fast, app-like experience on the mobile web
date: 2017-05-17
updated: 2017-05-17
tags:
  - blog
  - case-study

---

<figure>
{% Img src="image/T4FyVKpzu4WKF1kBNvXepbi08t52/1vNAz1DVJDIbNuZseehE.jpg", alt="Lancome detail", width="800", height="800" %}
</figure>

To drive both traffic and re-engagement, luxury cosmetics brand
Lancôme launched a Progressive Web App (PWA) with Mobify to deliver a fast,
app-like experience on the mobile web.

- 17% increase in conversions
- 53% increase in mobile sessions on iOS
- 8% increase in conversion rates on recovered carts via Push Notifications

## Challenge

Lancôme saw mobile traffic eclipse desktop traffic for the first time in 2016.
Despite a growing number of mobile site visitors, mobile conversion rates didn’t
match those for desktop. While 38% of shopping carts led to orders on desktop,
the mobile web conversion rate was only 15%. This disparity revealed that
consumers were experiencing significant obstacles when trying to purchase on
mobile. As the mobile web became a core focus area, Lancôme struggled to build a
fast and engaging experience for their mobile web shoppers.
 
### Can’t we just build an app for that?

At first, Lancôme considered building an e-commerce app for mobile, but decided
that an app only made sense for customers who visited regularly. They understood
that shoppers on Lancôme’s mobile site behave differently, and wouldn’t return
to an e-commerce app weekly, let alone daily. Lancôme wanted to build the right
user experience (UX) on all of their devices. The company needed a fast-loading,
compelling emobile experience, similar to what they could achieve with a native
app—but one that was also discoverable and accessible to everyone via the mobile
web.
 
## Solution

Instead of minimally updating their underlying site, Lancôme looked to PWA
technologies to provide an immersive, app-like experience. They took advantage
of service workers to deliver reliable performance on unstable networks and push
notifications for re-engagement. Their best-in-class PWA achieves a performance
score of 94/100 on Lighthouse, an automated tool for improving web page quality.
 
With the new PWA, the time until the page is interactive fell by 84%, compared
to their previous mobile experience, with a corresponding 15% decrease in bounce
rates. Lancôme saw their mobile sessions rise by more than 50%, and conversions
increase by 17%. The new strategy also delivered a much better user experience
across platforms. iOS is extremely important for Lancôme—65% of all users
landing on their PWA are on iPhones. With their new PWA, Lancôme saw a 53%
increase in session length and 10% bounce rate decrease among iPhone users
(despite the fact that the “Add to homescreen” menu item, push notifications,
and offline caching were unavailable due to lack of iOS support for PWA of
service workers).
 
Lancôme’s higher engagement rate resulted from the new site’s increased download
speeds and user-interface improvements. On Android devices (which support
service workers), Lancôme also took advantage of re-engagement technologies such
as push notifications, which became very popular with users: Over 18,000
shoppers have signed up for alerts since the site launched in October 2016. The
notifications look the same as those on native apps, and arrive even if the
browser is no longer running. Lancôme sends four or five alerts a month for
exclusive promotions and product releases. 8% of consumers who tap on a push
notification make a purchase, which is much higher than the desktop website
conversion rate. Lancôme also has great success in using push notifications to
reconnect with shoppers who’ve abandoned their carts. The new strategy has
delivered an 18% open rate on mobile, and conversion rates on abandoned carts
have increased by 8%.

All told, the PWA has been a tremendous success, helping the beauty giant make
great strides into the mobile web.

### Results 

**Overall**

- 84% decrease in time until the page is interactive 
- 17% increase in conversions
- 15% decrease in bounce rate
- 51% increase in mobile sessions

**iOS**

- 53% increase in mobile sessions on iOS
- 10% decrease in bounce rates on iOS

**Push** 

- 8% of consumers who tap on a push notification make a purchase
- 18% open rate from Push Notifications
- 12% increase in conversion rates on recovered carts via Push Notifications

