---
layout: post
title: Jumia sees 33% increase in conversion rate, 12X more users on PWA
description: |
    Traffic to Jumia's PWA has eclipsed that of their native app by more than 12 times and is still growing. Jumia also saw a 50% bounce-rate decrease
date: 2017-05-17
updated: 2017-05-17
tags:
  - blog
  - case-study

---

<figure>
{% Img src="image/T4FyVKpzu4WKF1kBNvXepbi08t52/85YtrA4AOFc6OdxoET1y.jpg", alt="Jumia detail", width="800", height="800" %}
</figure>

Jumia, a leading e-commerce website in Africa, [showcased their Progressive Web
App (PWA) journey](https://developers.google.com/web/showcase/2016/jumia) in 2016, outlining how they
delivered an app-like experience to users through modern web capabilities.
PWA has since proved to be far more than a buzzword—it’s now the de facto
way Jumia builds for mobile devices. They’ve integrated PWA across many of
their operations, including Jumia Travel.

- 33% higher conversion rate
- 50% lower bounce rate
- 12X more users versus native apps (Android & IOS)
- 5X less data used
- 2X less data to complete first transaction
- 25X less device storage required

## Challenges

In Jumia's main market, sub-Saharan Africa, 75% of the mobile connections are on
2G networks. Many users only have intermittent connectivity and visit the site
from low-end phones with data limitations. These two factors make it difficult
to induce users to download a data-heavy native app, leading to steep drop-off
rates and high customer-acquisition costs. “We integrated PWA technologies to
reduce friction. They work on most smartphones and tablets without an App Store
or Google Play account,” says Paul Midy, Jumia Travel CEO. “You don’t need an
email account, or a credit card, either.”
 
## Solution

Jumia Travel has enhanced and optimized all the various elements of their PWA
experience. They saw a dramatic 33% increase in conversion rates compared with
the previous mobile website. Traffic to their PWA has eclipsed that of their
native app by more than 12 times and is still growing. Jumia also saw a 50%
bounce-rate decrease.
 
Plus, Jumia Travel’s PWA uses 80% less data than the native app to complete the
first transaction. The PWA consumes 25 times less storage, and is much easier to
keep up-to-date. They’ve also built it to work offline-first, which makes a lot
of sense given the erratic mobile-network service experienced by many of their
users.
 
Jumia will continue using PWA technologies to reach their evolving base of
online shoppers. "Our PWA lets us find some of our highest-value customers,”
Midy concludes. “We’ll continue expanding the technology across all our
platforms, investing significant resources to maximize the potential scale. We
truly believe this is a new way to experience mobile—and we’re just getting
started."
