---
layout: post
title: "Submit your proposals for Interop 2024"
subhead:
    "Once again it's time to submit your proposals, as Interop 2024 is happening!"
description:
    "Learn more about how to submit a proposal for Interop 2024."
authors:
  - rachelandrew
  - robertnyman
  - foolip
  - nandunair
hero: "image/RYmV5NPuMZRoF3PVwIXTUpdYeQ23/ZZjlTqQijYN8FocvisWC.jpg"
alt: "A picture of three post-its and a marker pen."
date: 2023-09-14
tags:
  - blog
  - css
---

Over the past two years the Chrome team has successfully worked with our partners to improve the interoperability of the web. For [Interop 2022](/interop-2022-wrapup/) all major browser vendors and other stakeholders worked together to improve top browser compatibility issues identified by web developers. We repeated the process with [Interop 2023](/interop-2023/), which still has a few months to run yet is already seeing a huge improvement in scores. For Interop 2023, we also requested public proposals for features to include, which led to many great suggestions representing the needs of the wider web ecosystem.

<figure>
  {% Img src="image/RYmV5NPuMZRoF3PVwIXTUpdYeQ23/rK7xV8u6Jvf9oSl7VkCT.png", alt="The Scores for Interop overall: 62, Investigations: 0, and the scores per browser - 86 for Chrome and Edge, 74 for Firefox, 86 for Safari Technology Preview.", width="800", height="866" %}
  <figcaption>January 2023.</figcaption>
</figure>


<figure>
  {% Img src="image/kheDArv5csY6rvQUJDbWRscckLr1/25TJc2Fc8gJ4Qp9vQUNA.png", alt="The scores for Interop overall: 81, Investigations 59, and per browser, 96 for Chrome Dev and Edge Dev, 88 for Firefox Nightly, and 92 for Safari Technology Preview.", width="800", height="808" %}
  <figcaption>September 2023.</figcaption>
</figure>

It's been a huge success, with many features reaching interoperability, and we're happy to announce that Interop 2024 is happening. 

The first step is to gather suggested features, once again including ideas from the wider community, so the Interop 2024 proposal process is now open for submissions. Suggestions can include features that behave differently across browsers, or features that are not yet implemented in all browsers. Keep in mind that proposals with high quality specifications and web platform tests are [more likely to be included](https://github.com/web-platform-tests/interop/blob/main/README.md#requirements-for-focus-area-proposals), as this project is about reaching interoperability rather than specifying new features. The proposal submission process ends October 5, 2023.

Once the proposal period ends, the collected submissions will be discussed by browser vendors and other partners to determine the final list. It's likely that there will be more proposals than can be achieved during 2024, so some high quality proposals may not be selected. We are looking forward to reviewing [all the submissions](https://github.com/orgs/web-platform-tests/projects/3), and we'll post the final list here once Interop 2024 gets underway.

[Submit your proposals here](https://github.com/web-platform-tests/interop/issues/new/choose).
