---
layout: post
title: Infobae more than doubles time spent on mobile site with a Progressive Web App
description: |
    Infobae took advantage of service worker to deliver reliable performance on unreliable networks. Their best-in-class PWA achieved a performance score of 93/100 on Lighthouse, an automated tool for measuring web-page quality.
date: 2017-05-17
updated: 2017-05-17
tags:
  - blog
  - case-study

---

<figure>
{% Img src="image/T4FyVKpzu4WKF1kBNvXepbi08t52/UM0USY0eNoakaUIVQ5Hj.jpg", alt="Infobae detail", width="800", height="800" %}
</figure>

Founded in 2002 by lawyer, journalist, and media entrepreneur Daniel Hadad,
Infobae is one of Argentina’s first major digital-only news outlets. With 38
million monthly active unique users, it’s one of the most-read Spanish-language
news outlets in the world, thanks to exponential growth in Latin America.

- 230% longer sessions than on previous mobile site
- 3X more page views per session than on previous mobile site
- 5% bounce rate versus 51% on previous mobile site
 
## Challenge

Mobile accounts for 71% (and still growing) of Infobae’s total traffic, with 84%
of these users on Android phones. Engagement rates on mobile haven’t matched
those on desktop, however. Desktop readers are deeply engaged, spending on
average almost 27 minutes per session. On mobile, this number plummeted to just
3 minutes per session.
 
Despite a growing number of mobile site visitors, mobile bounce rates were much
higher than on desktop—51% versus 30%, respectively. Infobae believed the high
bounce rate and short session durations on mobile were caused by slow load
times. They looked to Progressive Web App (PWA) technologies for a solution. "We
know that speed is key in the culture of information, media, and news,” says
Infobae’s Founder and President Hadad.
 
## Solution

Instead of minimally updating their mobile site, Infobae rolled out a completely
new PWA to 10% of their overall monthly visitors. They saw immediate
improvements. Navigation within the site loaded in less than a second, which had
a huge affect on engagement. Average session duration grew to over 7 minutes,
compared with just 3 minutes on their mobile website. They also saw dramatically
lower bounce rates, down to an unprecedented 5% on the new PWA.
 
Infobae also took advantage of service worker to deliver reliable performance on
unreliable networks. Their best-in-class PWA achieved a performance score of
93/100 on Lighthouse, an automated tool for measuring web-page quality.
 
Infobae’s PWA is all about speed—for readers, journalists, advertisers, and
developers. The company took their PWA from conception to launch in just months,
showcasing their focus on digital experimentation and commitment to producing
high-quality reader experiences. PWA technologies will power their ambitious
plans to accelerate capabilities for mobile and position them for continued
growth.
 
“The transformation to digital journalism is driven by cutting-edge technology.
PWAs give modern publishers a strong, agile, and flexible infrastructure that
promotes rapid innovation and experimentation—things that are critical for long-
term success,” says Hadad. “We’re committed to digital speed at Infobae. We look
forward to PWAs powering our ambitions and accelerating our growth.”
 
{% Blockquote 'Daniel Hadad, founder & president, Infobae'%}
We have a passion for journalism and technology. Our new PWA will enhance
our newsroom’s work and the experience of millions of unique users who
choose Infobae to deliver captivating and relevant information for their
daily lives. We’re committed to innovation as we continue to drive the
future of news delivery.
{% endBlockquote %} 
 

### Performance metrics: desktop site, mobile site & PWA

<table>
<tr>
<th></th>
<th>Avg. session duration</th>
<th>Page views per session</th>
<th>Bounce rate</th>
</tr>
<tr>
<td>Desktop site</td>
<td>00:27</td>
<td>6</td>
<td>32%</td>
</tr>
<tr>
<td>Mobile site</td>
<td>00:03</td>
<td>2</td>
<td>51%</td>
</tr>
<tr>
<td>PWA</td>
<td>00:07</td>
<td>6</td>
<td>5%</td>
</tr>
</table>
