---
layout: post
title: Smart Lock for the Guardian
date: 2016-09-30
updated: 2016-09-30
tags:
  - blog
  - case-study

---

<figure>
{% Img src="image/T4FyVKpzu4WKF1kBNvXepbi08t52/Ptu1Kad5UFx2gZNf09pT.png", alt="Guardian smart lock screenshot", width="800", height="1422" %}
</figure>

### Results

- 44% increase cross-platform signed-in users
- 69% growth in app sign-ins after Smart Lock
- 7.9% increase in desktop sign-ins

[Download PDF Case study](https://storage.googleapis.com/web-dev-uploads/file/T4FyVKpzu4WKF1kBNvXepbi08t52/unhQhlpUkEAugIMgGO7M.pdf)

## Company

Guardian News & Media (GNM) publishes
[theguardian.com](https://theguardian.com), one of the largest English-speaking
quality newswebsites in the world. Since launching its US and Australia digital
editions in 2011 and 2013 respectively, traffic from outside of the UK now
represents over two-thirds of the Guardian’s total digital audience. In the UK,
GNM publishes the Guardian newspaper six days a week, first published in 1821,
and the world’s oldest Sunday newspaper, The Observer.

## Challenges

Signed-in users are critical to the Guardian’s future plans and features. For
example, hyper-tailored push, re-engagement via email, preservation of
personalization between hardware upgrades, or even effectively tracking users
between different platforms all rely on consistently identifying real people.
All of these directly influence engagement and monetization potential.

## Solution

In the 35 weeks since launching Smart Lock, the Guardian has seen a 44% increase
in cross-platform signed-in users, compared to 10% the 35 weeks leading up to
the launch. The overall rate of apps sign-ins have increased as well: from 51%
growth in the 35 weeks prior to launch, to 69% post-launch. Smart Lock has also
turned around desktop sign-ins; three months before implementing Smart Lock,
desktop sign-ins declined by 8.4%. Now, they’ve increased by 7.9%.

Smart Lock amplifies the work the Guardian does on apps and other platforms,
like Chrome, by converting newly signed-in app users to signed-in users
elsewhere. This increases the Guardian’s ability to have a joined-up portfolio-
wide view of its audiences and thereby, improves opportunities to deepen its
relationships, offer next-generation services like its unified history service,
and develop better reader recommendations.

It took two days to implement from first dev to app release.

{% Blockquote 'Tom Grinsted, Product Manager, the Guardian'%}
Being able to identify real people as individuals across our platforms
is a cornerstone for our analytics fidelity and insight, relationship
strategy, and future features. The substantial positive impact that
Smart Lock has had directly helps and amplifies our efforts.
{% endBlockquote %}

## Learn more about Smart Lock

Users save passwords to Google from Chrome or Android and passwords are made
available across platforms.

Find out more at: [g.co/smartlock#for-passwords](https://g.co/smartlock#for-passwords)
