---
layout: post
title: "Google I/O 2022: That's a wrap!"
subhead: >
  A roundup of the announcements from Google I/O this year. 
description: >
  A roundup of the announcements from Google I/O this year.
hero: image/kheDArv5csY6rvQUJDbWRscckLr1/spDtq47VLuwNmSKB19tl.jpg
alt: A bike in front of a large tent.
date: 2022-05-13
authors:
  - paulkinlan
tags:
  - blog
---

At [Google IO 2022](https://io.google/2022/products/web/) we shared updates on our progress to help create a web that is instant, and connects people, no matter their device or bandwidth. A powerful platform that delivers experiences that we once never thought possible in a browser. And one that people can trust to keep their data safe. Here's a recap on how we're making it easy for you to build experiences that people will love.

## An instant web

Great web performance is a partnership between the browser and web developers. That's why we've made it easy for you to measure how well your website performs with the three Core Web Vitals. Optimizing your Vitals results in a better user experience, and better discoverability through Google Search. Be sure to check out our session, [Core Web Vitals in the real world](https://io.google/2022/program/7cb6e1ad-504b-42d8-9ab6-105c48a65b80/) to learn how websites around the world are optimizing their scores to achieve better user experiences.

[Largest Contentful Paint (LCP)](/lcp/) is an important, user-centric metric for measuring perceived load speed. A fast LCP helps reassure the user that the page is useful, because it marks the point in the page load timeline when the main content has loaded. To learn more about this complex metric, check out our session, [A deep dive into optimizing LCP](https://io.google/2022/program/3d49f700-4e86-4a50-9f8a-1a2742bc4c22/).

<figure>
<a href="https://io.google/2022/program/3d49f700-4e86-4a50-9f8a-1a2742bc4c22/">
{% Img src="image/kheDArv5csY6rvQUJDbWRscckLr1/DzsyLVvbTlGL6MT3cHcW.png", alt="A still from a talk with the speaker sharing an LCP value of 52.7%", width="800", height="442" %}
</a></figure>

Another new performance metric is something we are calling [Interaction to Next Paint](http://web.dev/inp/) (INP). Unlike First Input Delay, it considers not just the first interaction, but all interactions on a page. INP therefore does a better job of capturing the interaction latency as experienced by the user. Learn more by checking out [The State of Responsiveness on the Web](https://io.google/2022/program/62e33209-bd18-48c5-801f-d6d1cc442e4b/) session. For help with your performance journey, be sure to [check out the new Performance Insights panel in Chrome DevTools along with many more updates](https://io.google/2022/program/6213f6fd-c940-4e80-b011-beec59d610f8/) based on your feedback.

## Powerful capabilities

Since last I/O, an array of new APIs have landed in stable Chrome. These unlock powerful new web experiences for the user. One of my favorite examples is how [Adobe brought Creative Cloud to the web, starting with Photoshop and Illustrator.](https://io.google/2022/program/b235121c-8e48-4cfb-89a6-1481c220fce1/)

We're also continuing to expand on the ways websites can integrate with the underlying operating system and hardware. Advanced apps now have the capability to seamlessly integrate with the operating system, so users can find the app on their desktop or homescreen, or easily access their files. We've also continued to improve installability, so be sure to [check out how to make a richer install experience](https://io.google/2022/program/a8a9892b-ae1d-4078-a818-2ff0b674a12b/).

<figure>
<a href="https://io.google/2022/program/a8a9892b-ae1d-4078-a818-2ff0b674a12b/">
{% Img src="image/kheDArv5csY6rvQUJDbWRscckLr1/bA4Q4h2lp1ZkBws5N5hi.png", alt="A still from a talk with the speaker showing examples of a richer install UI.", width="800", height="441" %}
</a></figure>

## Safe and secure

Chrome innovation extends to our work on user privacy and security. That's why we're taking a different approach by providing a path for developers to maintain functionality, while keeping the user safe. This is our [Privacy Sandbox vision](https://developer.chrome.com/docs/privacy-sandbox/). Learn more about the [progress we've made to phase out third-party cookies and land new APIs without cross-site tracking](https://io.google/2022/program/fd566197-8194-4989-91dc-6fd0173faa7e/). We have a number of new origin trials that you can participate in today that will help you preserve web functionality, while safeguarding user privacy. 

<figure>
<a href="https://io.google/2022/program/fd566197-8194-4989-91dc-6fd0173faa7e/">
{% Img src="image/kheDArv5csY6rvQUJDbWRscckLr1/Y2CyrX6t1IeG014OKBsn.png", alt="A still from a talk showing set-cookie code along with the speaker.", width="800", height="441" %}
</a></figure>

And to keep users safe from phishing, we need better authentication methods. We're removing the friction of sign on and passwords with passkeys, which you can learn more in our session, [A path to a world without passwords](https://io.google/2022/program/e3bb37a4-2723-4d72-a5b3-1a23abb94ac0/).

## Beautiful and delightful

This last year has seen huge improvements across all browsers in CSS and layout primitives. For Chrome, [RenderingNG](https://developer.chrome.com/blog/renderingng/) has made it possible to deliver a number of features that have been long hoped for by developers. Watch our [State of CSS](https://io.google/2022/program/9f58d739-87b1-42f0-b715-32584508a69b/) and explore new styling APIs available today and tomorrow: container queries, subgrid, color functions, or check out our [Shared Element Transitions](https://io.google/2022/program/81ed353d-20e4-4e9a-9b4d-d65b103cfc71/) talk to learn how we are working to bring seamless transitions between pages.

<figure>
<a href="https://io.google/2022/program/9f58d739-87b1-42f0-b715-32584508a69b/">
{% Img src="image/kheDArv5csY6rvQUJDbWRscckLr1/883tzmfbbcALNf8itivk.png", alt="A still from a talk featuring a speaker and a slide showing the CSS accent-color property.", width="800", height="440" %}
</a></figure>

## Simplifying web development

We share our innovation through Chromium, our open-source browser project that brings the web to Android apps, TVs and VR headsets, and is the engine powering other browsers. 

We're mindful that your priorities are for building features that work across many browsers. [Learn about how we, along with other browsers, are working together to make it easier to develop for the web](https://io.google/2022/program/6c749c36-e85f-470f-a981-49b1ddbe9d20/) by ensuring features are interoperable so you can focus on building rich web experiences for users.

Finally, be sure to check out our [What's new for the web platform](https://io.google/2022/program/3c60e411-5340-4c54-a037-3aceb2825b16/) keynote where we'll walk you through the latest web platform features and their availability across browsers so you know when you can rely on them in your sites and apps.

<figure>
<a href="https://io.google/2022/program/3c60e411-5340-4c54-a037-3aceb2825b16/">
{% Img src="image/kheDArv5csY6rvQUJDbWRscckLr1/QuNDlrtCHpe5kbgmnsXT.png", alt="A still from the What's new for the web platform talk.", width="800", height="440" %}
</a></figure>