---
layout: post
title: 'Finding courage and inspiration in the developer community'
authors: 
  - monikajanota
hero: image/jL3OLOhcWUQDnR4XjewLBx4e3PC3/5bk29uMufFZlPD09mRxV.png
thumbnail: image/jL3OLOhcWUQDnR4XjewLBx4e3PC3/KH1ttCJSLsVcgdkmJiTx.png
alt: 'Community highlights'
subhead: >
  Web Google Developers Experts on how mentoring programs empowered them to become leaders.
description: >
  Web Google Developers Experts on how mentoring programs empowered them to become leaders.
date: 2022-05-09
tags:
  - blog
  - community
---


How do we empower women in tech and equip them with the skills to help them become true leaders? One way is learning from others' successes and failures. Web GDEs—[Debbie O'Brien](https://developers.google.com/community/experts/directory/profile/profile-debbie-o-brien), [Julia Miocene](https://developers.google.com/community/experts/directory/profile/profile-julia-miocene), and [Glafira Zhur](https://developers.google.com/community/experts/directory/profile/profile-glafira-zhur)—discuss the value of one to one mentoring and the impact it has made on their own professional and personal development.

[A 2019 study](https://www.ensono.com/company/news-press/ensono-launches-women-in-tech-study/) showed that only 25% of keynote speakers at tech events are women, meanwhile 70% of female speakers mentioned being the only woman on a conference panel. One way of changing that is by running programs and workshops with the aim of empowering women and providing them with the relevant soft skills training, including public speaking, content creation, and leadership. Among such programs are the [Women Developer Academy](https://events.withgoogle.com/women-developer-academy-europe/) (WDA) and the [Road to GDE](https://events.withgoogle.com/road-to-gde/), both run by Google's developer communities. 

With more than 1000 graduates around the world, WDA is a program run by [Women Techmakers](https://www.womentechmakers.com/) for professional IT practitioners. To equip women in tech with speaking and presentation skills, along with confidence and courage, training sessions, workshops, and mentoring meetings are organized. Road to GDE, on the other hand, is a three-month mentoring program created to support people from historically underrepresented groups in tech on their path to becoming experts. What makes both programs special is the fact that they're based on a unique connection between mentor and mentee, direct knowledge sharing, and an individualized approach. 

<figure>
{% Img src="image/kheDArv5csY6rvQUJDbWRscckLr1/qs69cyfMqlAqbdOLQLJL.jpeg", alt="A speaker in front of a bright colored screen.", width="800", height="534" %}
  <figcaption>Julia Miocene</figcaption>
</figure>

Some Web GDE community members have had a chance to be part of the mentoring programs for women as both mentors and mentees. Frontend developers Julia Miocene and Glafira Zhur are relatively new to the GDE program. They became Google Developers Experts in October 2021 and January 2022 respectively, after graduating from the first edition of both the Women Developer Academy and the Road to GDE; whilst Debbie O'Brien has been a member of the community and an active mentor for both programs for several years. They have all shared their experiences with the programs in order to encourage other women in tech to believe in themselves, take a chance, and to become true leaders.

## Different paths, one goal 

Although all three share an interest in frontend development, each has followed a very different path. Glafira Zhur, now a team leader with 12 years of professional experience, originally planned to become a musician, but decided to follow her other passion instead. A technology fan thanks to her father, she was able to reinstall Windows at the age of 11. Julia Miocene, after more than ten years in product design, was really passionate about CSS. She became a GDE because she wanted to work with Chrome and DevTools. Debbie is a Developer Advocate working in the frontend area, with a strong passion for user experience and performance. For her, mentoring is a way of giving back to the community, helping other people achieve their dreams, and become the programmers they want to be. At one point while learning JavaScript, she was so discouraged she wanted to give it up, but her mentor convinced her she could be successful. Now she's returning the favor. 

<figure>
{% Img src="image/kheDArv5csY6rvQUJDbWRscckLr1/XvxCXzf2uuSjx4znwoUN.jpeg", alt="Two people taking a selfie in front of a room set up for a workshop.", width="800", height="534" %}
  <figcaption>Debbie O'Brien</figcaption>
</figure>

As GDEs, Debbie, Glafira, and Julia all mention that the most valuable part of becoming experts is the chance to meet people with similar interests in technology, to network, and to provide early feedback for the web team. Mentoring, on the other hand, enables them to create, it boosts their confidence and empowers them to share their skills and knowledge—regardless of whether they're a mentor or a mentee. 

## Sharing knowledge

A huge part of being a mentee in Google's programs is learning how to share knowledge with other developers and help them in the most effective way. Many WDA and Road to GDE participants become mentors themselves. According to Julia, it's important to remember that a mentor is not a teacher—they are much more. The aim of mentoring, she says, is to create something together, whether it's an idea, a lasting connection, a piece of knowledge, or a plan for the future. 

Glafira mentioned that she learned to perceive social media in a new way—as a hub for sharing knowledge, no matter how small the piece of advice might seem. It's because, she says, even the shortest Tweet may help someone who's stuck on a technical issue that they might not be able to resolve without such content being available online. Every piece of knowledge is valuable. Glafira adds that, "Social media is now my tool, I can use it to inspire people, invite them to join the activities I organize. It's not only about sharing rough knowledge, but also my energy." 

Working with mentors who have successfully built an audience for their own channels allows the participants to learn more about the technical aspects of content creation—how to choose topics that might be interesting for readers, set up the lighting in the studio, or prepare an engaging conference speech. 

## Learning while teaching 

From the other side of the mentor—mentee relationship, Debbie O'Brien says the best thing about mentoring is seeing the mentees grow and succeed: "We see in them something they can't see in themselves, we believe in them, and help guide them to achieve their goals. The funny thing is that sometimes the advice we give them is also useful for ourselves, so as mentors we end up learning a lot from the experience too." 

<figure>
{% Img src="image/kheDArv5csY6rvQUJDbWRscckLr1/zY4aDIspm31q0C9vGogv.jpeg", alt="A speaker presenting remotely with a headset.", width="800", height="534" %}
  <figcaption>Glafira Zhur</figcaption>
</figure>

Both Glafira and Julia state that they're willing to mentor other women on their way to success. Asked what is the most important learning from a mentorship program, they mention confidence—believing in yourself is something they want for every female developer out there.  

## Growing as a part of the community

Both Glafira and Julia mentioned that during the programs they met  many inspiring people from their local developer communities. Being able to ask others for help, share insights and doubts, and get feedback was a valuable lesson for both women. 

Mentors may become role models for the programs' participants. Julia mentioned how important it was for her to see someone else succeed and follow in their footsteps, to map out exactly where you want to be professionally, and how you can get there. This means learning not just from someone else's failures, but also from their victories and achievements. 

Networking within the developer community is also a great opportunity to grow your audience by visiting other contributors' podcasts and YouTube channels. Glafira recalls that during the Academy, she received multiple invites and had an opportunity to share her knowledge on different channels. 

Overall, what's even more important than growing your audience is finding your own voice. As Debbie states: "We need more women speaking at conferences, sharing knowledge online, and being part of the community. So I encourage you all to be brave and follow your dreams. I believe in you, so now it's time to start believing in yourself."
