---
layout: post
title: 'GDE community highlight: Nishu Goel'
authors: 
  - monikajanota
hero: image/jL3OLOhcWUQDnR4XjewLBx4e3PC3/5bk29uMufFZlPD09mRxV.png
thumbnail: image/jL3OLOhcWUQDnR4XjewLBx4e3PC3/KH1ttCJSLsVcgdkmJiTx.png
alt: 'Community highlights'
subhead: >
  Nishu Goel is a renowned web engineer from India, Google Developer Expert for Angular and web technologies. She told us about her community involvement, career plans and the best ways to learn web development.
description: >
  One of a series of interviews with members of the Google Developers Experts (GDE) program.
date: 2022-04-05
tags:
  - blog
  - community
---

<figure>
{% Img src="image/kheDArv5csY6rvQUJDbWRscckLr1/YcD8pQOpwfcHv2iCw5lW.jpeg", alt="Nishu on stage.", width="800", height="533" %}
</figure>

Nishu Goel is a renowned web engineer from India, Google Developer Expert for Angular and web technologies, Microsoft Most Valuable Professional. She's the author of [Step by Step Angular Routing](https://www.amazon.com/Step-Angular-Routing-Nishu-Goel/dp/9388511662) (BPB, 2019) and [A Hands-on Guide to Angular](https://www.educative.io/courses/a-hands-on-guide-to-angular) (Educative, 2021) as well as the author of Web Almanac 2021 JavaScript chapter. Nishu currently works at epilot GmbH as a full stack engineer.  She told us about her community involvement, career plans and the best ways to learn web development.

**Monika**: Let's start with your story. What inspired you to become a developer and take on an active role within dev communities?

**Nishu**: I got my bachelor's degree in computer science, we studied data structures, and that's where the interest in programming started. During the third year of engineering, a connection with the developer community was established through my participation in the Microsoft Imagine Cup Nationals competition where we presented solutions through code. The idea of the application we built was to bring educational opportunities to local students, especially girls. I met some very inspiring people, both contestants and organizers in this journey. 

In 2018, my professional career took off, and I started working with Angular. Angular became the primary technology that connected me to the GDE program. Around the same time, I started writing blog posts and creating content around the subject I was working on and learning . Dhananjay Kumar helped me get started on this journey and ensured to keep me on track. My first articles tackled the basics of Angular. Soon after I started speaking at events-the first one being ngNepal, Nepal's Angular Conference. This led to more speaking invitations about Angular and web technologies. 

<figure>
{% Img src="image/kheDArv5csY6rvQUJDbWRscckLr1/ujceg3BgclYOgIwDjtt7.jpeg", alt="Nishu and other people from ng-india.", width="800", height="533" %}
</figure>

**Monika**: What's your professional experience technology-wise?

**Nishu**: It was all about Angular and web components for the first two years. I was using Angular for building the web, but soon I decided to go beyond that and explore other fields. I didn't want to limit myself in case I'd have to switch projects. That's how I started creating web components in Angular to use in other frameworks. 

The first thing I did was to create web components using Angular. I published it to npm and used it as a demo in a React project. I've discussed this during some of my talks and presentations later. My next job required using React and Typescript. Now, because I was working with React, I wasn't just using one framework anymore, but the web in general. At that moment I learned a lot about the web, especially web performance. That's when I had to start thinking about the [Largest Contenful Paint (LCP)](/lcp/) or [First Contentful Paint (FCP)](/fcp/), which means how much time it will take your application to load or what's going to be the maximum time for the page to render. I have been working towards choosing best practices and an improved performance of the applications. 

Because of this interest in web performance, I got involved in the Web Almanac and wrote [the JavaScript chapter](https://almanac.httparchive.org/en/2021/javascript). Web Almanac is an annual report on the state of the web in general&mdash;it tells us how people are using different features. Last year 8.6 million websites were screened, the data was analyzed and presented in the report. The report includes statistics like the usage of the `async` and `defer` attributes in a `<script>` element. How many websites are using them correctly, how many are not using that at all, and how many improved those compared to 2020. The last Web Almanac report mentioned that around [35% of websites used two attributes on the same script](https://almanac.httparchive.org/en/2021/javascript#fig-9), which was an anti-pattern, decreasing the performance. This was pointed out last year, and this year we tried to see if the situation improved. I also spoke at ngConf and Reliable Dev Summit, where I focused on the performance of the web. 

<figure>
{% Img src="image/kheDArv5csY6rvQUJDbWRscckLr1/2jhiM4MDkLxZP0FzxjN0.png", alt="Print edition of the Web Almanac.", width="800", height="454" %}
</figure>

**Monika**: You're also very much involved in giving back to the community. Lately you've been volunteering with a Ugandan NGO YIYA&mdash;how did it start and what was the main point of that cooperation?

**Nishu**: It started with the GDE team informing us about the volunteering opportunity with YIYA. The Ugandan NGO was looking for engineers to help them with either the content preparation or technical features. The program aims to empower school-aged children in Uganda and offer them education opportunities using the technologies available locally&mdash;not computers or textbooks, but rather basic keypad phones and radios. The children would dial a certain number and receive a set of information, dial another one for more insights, and so on. It became even more useful during the pandemic.

Since I've always been involved with the community and sustainable development goals, I decided to reach out. After a meeting with the YIYA team, I offered my help with the Python scripts or any bugs they came up with, any issues with the portal. We worked together for a brief amount of time. 

**Monika**: What are your plans for 2022? Is there anything you're focusing on in particular?

**Nishu**: I'm switching jobs and moving to another country. I'll be working on the web in general, improving the site performance, and also on the backend, using Golang. I'll continue to zero in on the web performance area since it's very interesting and complex, and there's a lot to understand and optimize. Even now, after dedicating a lot of my time to that, there's still so much to learn. For example, I'd love to understand how using a CDN for my image resources would help me make my app even faster. I want to become THE expert of web performance&mdash;I'm gradually getting there, I like to believe :)

**Monika**: You've mentioned starting to write at a point when you were not an expert, you were just writing what you were learning. What would your advice be to new developers coming through and feeling they don't have anything to share? 

**Nishu**: That's exactly how I felt when I started writing. I thought that maybe I should not put this out? Maybe it's just wrong? I was worried my writing was not going to help the readers. But the important thing was that my writing was helping me. I would forget things after some time and then come back to something I wrote earlier. Writing things down is a great idea. 

<figure>
{% Img src="image/kheDArv5csY6rvQUJDbWRscckLr1/1Cs78KYoGM3NzL9VzdZH.jpeg", alt="The book Angular Routing on a table.", width="800", height="600" %}
</figure>

So I would suggest everyone&mdash;just write, at whatever stage. Even if you've only finished one part of a course you're going through&mdash;you're learning by writing it down. A piece of information that you got to know at some point may be useful to others who don't know that yet. You don't need to be an expert. Writing will help you. And anyone, at any stage of their career. 

**Monika**: It's best to follow people who just learned something because they know all the things they had to figure out. Once you're an expert, it's hard to remember what it was like when you were new. And any advice for someone who's just getting into web development? 

**Nishu**: Many people ask which framework they should choose when they're starting, but I think that's not the right question. Whatever we are learning at any point should be useful at a later stage as well. I would advise anyone to drop the limitations and start with HTML or JavaScript&mdash;that's going to be profitable in the future.

And then take any opportunity that comes your way. This happened to me when I stumbled upon information about the Web Almanac looking for authors. I just thought, "oh, this is interesting, this may help everyone with the performance side of things". That's how I became a content lead for the JavaScript chapter, and I've spent six months writing it. So I think it's just about grabbing the opportunities and working hard. 

**Monika**: Do you have any predictions or ideas about the future of web technology in general? What's going to be the next hot topic? What's going to be growing fast? 

**Nishu**: I love the fact that we're able to run servers within browsers now, this is a great advancement. For example, running Node.js from the browser has been introduced lately, meanwhile in the past we could not run anything without having Node.js installed in our systems. Now we can do anything from the browser. This is a huge step further in the web ecosystem. And the OMT&mdash;Off the Main Thread. Working on the threads is going to be much improved as well. Web Assembly is advancing and enables developers to do that, and I think that is the future of the web ecosystem. 
