---
layout: post
title: 'A win-win situation'
authors: 
  - monikajanota
hero: image/jL3OLOhcWUQDnR4XjewLBx4e3PC3/5bk29uMufFZlPD09mRxV.png
thumbnail: image/jL3OLOhcWUQDnR4XjewLBx4e3PC3/KH1ttCJSLsVcgdkmJiTx.png
alt: 'Community highlights'
subhead: >
  GDE Enrique Fernandez Guerra on open sourcing his NGO HelpDev.
description: >
  GDE Enrique Fernandez Guerra on open sourcing his NGO HelpDev.
date: 2022-07-14
tags:
  - blog
  - community
---

<figure>
{% Img src="image/kheDArv5csY6rvQUJDbWRscckLr1/PD45CkrdOsFz3xyB5gJ8.jpeg", alt="Enrique on stage wearing a headset mic.", width="800", height="558" %}
</figure>

**Monika:** Let's start by learning a bit about you. What was your journey as a developer? What are you up to now?

**Enrique:** I'm [Enrique](https://twitter.com/CKGrafico), but everyone calls me Quique. I've been a developer ever since I can remember. I was probably around 13 years old when me and my friend started to program very basic websites, we called them [Homer Simpson-like websites](https://simpsons.fandom.com/wiki/Homer%27s_Web_Page#:~:text=Homer%27s%20Web%20Page%20is%20a,didn%27t%20gain%20many%20hits.)—just for fun and for the sake of learning. Step by step, I continued programming on my own. In the end I decided to study engineering, but instead of computer science, I chose telecommunication.   

I've been working as a front-end developer for as long as I can remember. I worked with many frameworks, including Angular, Vue, and React. Nowadays I'm based in Romania, working as a country director of engineering at my company. We're hiring truly outstanding professionals and I'm happy I get to share with them our work culture and help them along the way. I still consider myself a frontend specialist, but I'm more focused on managing people and projects. 

**Monika:** Have you always been an active member of the community?

**Enrique:** All this time I've been involved in various communities, I love this kind of networking. I started speaking at events and conferences, sharing content, and creating open-source libraries.   

Nine years ago I decided to put my skills into use and fund [HelpDev](https://helpdev.org/)—an NGO focused on helping other NGOs with website development. It runs in my family—everyone is involved in NGOs, we love giving back to the community.  

With HelpDev, the initial idea was to combine two kinds of activity—helping NGOs without resources and supporting young developers without any professional experience who wanted to improve their resumes. If you don't have any experience, it may be hard for you to secure a job since every company now asks for experience. We only work with NGOs that don't have any financial resources; if they're able to pay, we make sure they hire a contractor who'll be able to carry out what they need. 

We started as a huge group of 50 people, which turned out to be impossible to manage properly. We needed to change the way of operating and continued for the next three to four years in a small group of five. At that point we were creating simple websites with Wordpress for our NGOs. When the pandemic started, we needed to rethink our activity and find better ways to make things happen. 

**Monika:** And what did you change?

**Enrique:** At the beginning of 2022, we moved all the content from Wordpress to [GitHub](https://github.com/helpdev), making the websites open-source. All the code is public now. We're using [Storyblok](https://www.storyblok.com/)—a headless CMS which offers an API with all the content and is easy to manage for non-technical users. Some people we're working with are very engaged volunteers but have limited technical knowledge. The tool needs to be really easy to allow them to operate on their own without problems.   

For the frontend, we're using a technology called [Nuxt](https://nuxtjs.org/) based on [Vue](https://vuejs.org/). Combining those tools makes it easy for us to create more websites, only having to change color, branding, and content. We can use the same components for different websites.   

Hopefully this year we'll finish the migration of the websites to the new platform. Now the NGOs don't have to pay anything for maintaining a website, just the domain, but other than that we ensure that the hosting is free. [Storyblok](https://www.storyblok.com/) is actually sponsoring us, and thanks to that, we have a free license. The companies we're partnering with usually help our NGOs with some assets they might need, for example, providing them with new branding.   

Sometimes NGOs are founded in times of need—that happened after a devastating earthquake in Nepal, when organizations didn't have time to set everything up properly. We came to help.   

Our goal is to make volunteering for NGOs as easy as possible—accessible anytime, from any place on earth. Open-sourcing our work was a way to do that. Now anyone can answer a request and fix a bug, or improve a website in some way. It allows more people to be engaged, but spend less time working on something. 

**Monika:** While creating HelpDev, after the initial hype, did you work with anyone? Did anyone help you?

**Enrique:** In the beginning, when there were 50 of us, the meetings were chaotic and we were not able to reach an agreement. In the end, four founders stayed to help me turn the HelpDev project into an official, registered NGO. They're still with the organization, working as vice presidents or advisors, and tackling financial and legal issues. Now, since we operate in an open-source model, we don't need that many people to be engaged all the time. It works really well. 

**Monika:** HelpDev is an NGO helping other NGOs. Do you have a particular focus while choosing your partners?

**Enrique:** Before becoming an open-source NGO we were only working with Spanish NGOs. Everything was done in a traditional way—face-to-face meetings, planning, phone calls, legal actions, and so on. Nowadays we're no longer limited to that, we can work with anyone around the world. We're also no longer  focussed on offering each of our partners an individual solution anymore—their websites are currently unified, which makes it easier to maintain and further develop. Whenever I create a new component, I can use it for all the websites. What is more, with [Storyblok](https://www.storyblok.com/), the NGOs will be able to implement most of the changes on their own.   

The Spanish NGOs we previously worked with are really diverse, each having a different focus and different priorities. [NeedU](https://need-u.org/) works with homeless people in Barcelona, [Asocciación APISF](https://apisf.org/) supports doctors in Africa—the scope is really wide. In Spain, we have many NGOs for different causes and people frequently volunteer. It's quite popular. 

**Monika:** What's next for HelpDev? What's going to change after moving to GitHub?

**Enrique:** The challenge I'm currently facing is transforming an NGO into a [GitHub project](https://github.com/helpdev). Every community member knows how GitHub works—you have templates for issues and people helping with your request. It's not just libraries—I believe we can have much more than that. I'd love the whole project to be maintained entirely by the community—obviously our core team would still coordinate the main library and implement all changes if needed. Nonetheless,  all the bugs, new components, and small issues will eventually be fixed by volunteers around the world. I'm 100% sure community members would be eager to help us with that. And it's also beneficial for them—many of our requests are tagged as ‘Good First Issue' on GitHub, meaning that they're not technically challenging and would be a good fit for beginners who are just starting to build their portfolio. For example, right now we don't have a component for Carousel, but it's super easy to do.  Everyone is welcome to join and help.   

For us, it's just as we planned from the beginning—helping both NGOs in need and young developers. 

**Monika:** Are you involved in any other community activity right now?

**Enrique:** Oh yes! I also created a web app called [Talento para tu evento](https://talentoparatuevento.tech/) (Talent for your event). Again, its goal is to help organizers looking for a speaker who can deliver a presentation on JavaScript and connect them with tech professionals searching for opportunities to share their knowledge. The whole idea is to be free of unconscious bias when  choosing a speaker. That's why all the personal info about the person is anonymized; an organizer will be choosing based on experience and proposed topics. I hope this will help underrepresented groups, for example, women, get the opportunities they deserve. 

**Monika:** What motivated you to join the [Google Developer Experts](https://developers.google.com/community/experts) community?

**Enrique:** I've always been involved in community activities. One day a friend of mine who is also a GDE—[Jorge del Casar](https://twitter.com/JorgeCasar)—invited me to the program. Our paths actually crossed 12 years ago—at that point we were both engaged in dev communities in our area. I thought it would be a great idea to join the GDE community. I even told the team during the interview that I'm not here for the swag (which is, of course, nice), but because I love interacting with people and chatting about technology, especially directly, during conferences and workshops. Being a Google Developer Expert also lets me exchange ideas and knowledge with the brightest minds in the industry, people who know a hundred times more than me—I appreciate their experience and expertise.   

After joining the program, I also took part in Women Developer Academy as a mentor in 2021. It was a unique and inspiring experience—being able to mentor someone and put my knowledge into good use.   

I also discovered new ways of sharing with a community. Last year I created a podcast and invited ten people from the industry to talk, not about technology but about themselves, to learn who they really are.   

All of this wouldn't be possible without the GDE community. We're in touch on Slack, we see each other during different meet-ups and conferences, we have a chance to inspire each other. 

**Monika:** Would you say that developers have the resources and ability to change the world for good?

**Enrique:** I'm sure they do. In fact, not only developers, but all the professions out there have a lot to offer. The problem is often the people—we grow up in a society that pressures us to pursue perfection, do more than others, try harder. I believe sometimes it's good to stop for a moment and think that doing something for free, even though it doesn't bring you money, will bring you other kinds of benefits that money cannot buy.  

We're now very well paid, it's a good moment for our profession. We can spare a moment to help others by mentoring, sharing knowledge, or teaching. 

**Monika:** What would you say to someone who wants to follow in your footsteps?

**Enrique:** I think that for me, one of the most important learnings of my professional career was not to be too specialized, not to focus on just one technology. It's better to enjoy what the industry has to offer. Even though I'm working on frontend, I've also tried a bit of DevOps, backend, IoT, and apps. I don't really care about being the best in Angular or any other framework. My goal is rather to be a good professional than just a good developer. As a hiring manager, I prefer a professional who maybe needs to improve their technical skills, but who is a well-organized, effective communicator. 
