---
layout: post
title: 'GDE community highlight: Alba Silvente Fuentes'
authors: 
  - monikajanota
hero: image/jL3OLOhcWUQDnR4XjewLBx4e3PC3/5bk29uMufFZlPD09mRxV.png
thumbnail: image/jL3OLOhcWUQDnR4XjewLBx4e3PC3/KH1ttCJSLsVcgdkmJiTx.png
alt: 'Community highlights'
subhead: >
  Alba Silvente Fuentes is a Google Developer Expert, we talked to her about making coding and community-building human.
description: >
  One of a series of interviews with members of the Google Developers Experts (GDE) program.
date: 2022-09-22
tags:
  - blog
  - community
---

<figure>
{% Img src="image/kheDArv5csY6rvQUJDbWRscckLr1/TorTqrnIdn5WAXwPKLgS.jpeg", alt="Alba with a speaker lanyard.", width="800", height="598" %}
</figure>

**Monika:** What products are you working with? What's your professional focus, and what tools make your day-to-day work easy and efficient? 

**Alba:** Most of my work on the frontend is done in Vue 3, with the new Webpack for the ecosystem called [Vite](https://vitejs.dev/), with semantic HTML, [Tailwind CSS](https://tailwindcss.com/), and sometimes with [Nuxt.js](https://nuxtjs.org/)—depending on the specifics of the project. Most of the time I'm creating web applications, although recently I also worked on creating Chrome extensions.

I usually focus on the frontend part—building components—but I also like to keep in mind the project architecture, especially taking into account maintainability, performance, and scalability. That's why the content I'm creating in the community includes topics like Atomic Design, Jamstack, and design systems—I like to learn about new architectures that catch on. 

And if there are tools that can't be missed in my day-to-day, these are: VS Code synchronized with my account to add extensions such as [Volar](https://marketplace.visualstudio.com/items?itemName=vue.volar), Eslint, and Prettier; Notion to document my work and for content creation; Chrome extensions like Toby, Web Vitals metrics, and Axe; and [Fig.io](https://fig.io/) for the terminal.

**Monika:** How did you get here? When did you decide to focus on web development and frontend?

**Alba:** I studied image and sound engineering in telecommunications, so nothing directly related to web development. During my studies, I learned the basics of coding with C and C++. When I realized I had a knack for programming, I decided to follow that path and dive deeper into web development. During my third year of college, we were required to do an internship, and since I wasn't sure what I wanted to do, I chose a web agency—there I was taught PHP, HTML, CSS, and jQuery, working as a full-stack developer.

This made me realize that I actually prefer frontend development, I really liked what I was doing and wanted to focus just on that. So I started learning about frontend frameworks—Vue, React, and Angular. I tried all of them to finally fall in love with Vue.

**Monika:** What do you think is the next big thing for web technologies?

**Alba:** For me, the next big thing is about the changes going on with browsers like Chrome. The way we're improving CSS, the use of WebGL, and other JavaScript APIs, the accessibility standards, and so on. We can create a world inside a browser, just like in video games, or focus on making it accessible for everyone, inclusive.

The future is to improve the way we use the web, so that performance is no longer a problem because we have it covered by all the emerging technologies. And so we can focus on creating value, digitizing our daily tasks and automating what wastes our time.

**Monika:** What's the idea behind your podcast "No me da la vida"?

**Alba:** When I became a content creator, I started writing articles in English. At that time, I moved to the Netherlands and thought it would also help me learn the language to use it professionally.

My first language is Spanish, but back then I did not think about creating anything specifically for the community in Spain. The idea emerged when I met my co-host—I thought it would be good to create something together. So we joined forces and decided to give the podcast format a try. 

One idea led to another—we wanted to create a space where less well-known people could talk about their experiences in the industry, but decided to focus on women. It was also an opportunity for us to meet great professionals. Thanks to the podcast, we got to know them and establish relationships.

Of course, the ultimate goal was to exchange knowledge and learn from our guests. It's rarely about the frontend; the co-host and I are both frontend developers, so we liked the idea of being able to bring in people with other roles in the tech industry to tell us more about themselves. So far, we've had a chance to chat about AI, product management, and much more. It's fascinating.

**Monika:** How do you keep your audience engaged?

**Alba:** That's an interesting question! Actually, I'm lucky to be working with an expert. My co-host, Miriam, is creating content for social media, so we have this part covered. We shoot many short clips and share those on TikTok and Instagram, but also on our LinkedIn profile. The idea is to get people interested in the topic—only reveal a bit of the conversation and encourage them to find out what's next.

We also agreed that we should invite the truly engaged followers—people who know us and our work. We decided to build a community on Discord to have everything in one place, this way it's easier for our audience to follow the podcast. It also creates an opportunity to interact, and exchange thoughts. 

We're planning to organize live coding sessions or events at Twitch, Discord and such. It'll give us an opportunity to actually interact with our community, chat in real time and have fun together. We want to get to know our audience and with podcasts, the options are limited.

Our podcast also has a section called "Cuéntame tus Penurias" ("Tell me about your hardships")—the guests tell stories of how they failed or suffered in their jobs working in the tech industry. The stories are not necessarily tech-related, they may tackle mental health, legal issues and so on. The audience can relate, but also offer some advice or help find a solution to the problem. This type of engagement is important because it shows that we're all just humans. 

**Monika:** Do you see the industry changing, becoming more inclusive?

**Alba:** As a content creator and blogger I have met many people in the community, most of them inclusive and always reflecting on their actions, but I could say I live in a sort of bubble.

People who listen to our podcast and form a community around it are very inclusive and open-minded, but the thing is I don't really leave that circle that often. My closest environment is extremely friendly and inclusive. But on the other hand, I think we need to start somewhere. We can start to improve some things with a certain group of people, and they would later spread the word.

**Monika:** What's important while building a community?

**Alba:** I believe that it's crucial to have the right people organizing the events. Whenever I attend a meetup here in Amsterdam, I can feel that the organizers are relatable and human—going through difficulties, optimizing the way they work and talking about it openly. They would admit they feel nervous before a speech, and it makes the audience feel better around them. 

For example, watching prepared tutorials on YouTube won't give you the same feeling.The creators of those don't make mistakes, unless it's a livestream, you don't see their real reactions, they have scripts prepared for that.

Communities—for example, Google Developer Groups—are great, because you feel that you can fail live, and they'll still love you. It's amazing to feel that people around are just the same as me, and we can grow together. 

<figure>
{% Img src="image/kheDArv5csY6rvQUJDbWRscckLr1/D2nOKPybx9AqsrkKC7KF.jpeg", alt="Alba and other attendees in front of a Google sign.", width="800", height="600" %}
</figure>

**Monika:** What's your story as a Google Developer Expert in web technologies? Would you recommend the program to a friend?

**Alba:** My story as a GDE goes back to the beginning of the pandemic, when I was creating a lot of content. I met a few community members, one of them was Debbie O'Brien, who's also a GDE and an amazing supporter of women in tech. She appreciated my work and encouraged me to apply to the GDE program. Only problem—back then I did not know what it was! I was just starting my adventure with the dev community. It never occurred to me that I could be called an Expert. 

I followed Debbie's advice and created a portfolio of all my contributions. The application process went really well, and I believed my knowledge and experience are truly valuable to the community. 

Being a GDE is really cool. I'm learning so much from the community! I now spread the word about the program and hope some of my friends and colleagues will give it a try soon. 

**Monika:** What are your activities in the community besides blogging and podcasting? Do you do open source?

**Alba:** When I first got involved in open source projects, I created more documentation than actual code. Now I'm working on some boilerplates and demo projects for the new and upcoming technologies, for example, [Nuxt 3](https://v3.nuxtjs.org/). My goal is to help people who want to start building an app quickly—they can just use those pieces of code. I've never created a library of my own, I just contribute to and try to improve those that exist.

I was also quite engaged in hackathons—contests where organizers ask you to build an app, make it open source, and prepare documentation for it. You would not get the prize if any of those were missing. And I won one of those! I created a [Potato Mood Generator](https://potatizer.dawntraoz.com/). [You can read all about it here](https://www.dawntraoz.com/blog/random-potato-mood-generator-do-app-platform/).

I also host workshops where I teach people how to code  a website from scratch using Jamstack technologies, a headless CMS, and a Static Site Generator. I really prefer hosting those workshops over delivering speeches. I love seeing how people are learning as we go—you don't have that during a talk. After a speech, you may receive some feedback, but you won't see someone's finalized project. I love how everyone is typing together during a workshop. 

**Monika:** And what makes a good workshop?

**Alba:** You need to always explain the basics to make sure everyone understands. I try to explain each step in detail — the attendees need to know the process. I also always create a little glossary of new terms to be looked up during the class.

During the workshop, it's crucial to set time to debrief and check the different projects' status after completing each step. I encourage the attendees to ask questions as often as they need. 

So to sum up—it's all about communication. Ask the right questions, try not to lose people's attention, just be there for them. That's the best way to teach someone something new. 
