---
layout: post
title: 'Community highlight: Olutimilehin Olushuyi'
authors: 
  - alexandrawhite
hero: image/VbsHyyQopiec0718rMq2kTE1hke2/8nibxhPpYh7CcJmZubSa.png
alt: 'Learn Accessibility! Community highlight.'
thumbnail: image/VbsHyyQopiec0718rMq2kTE1hke2/8nibxhPpYh7CcJmZubSa.png
subhead: >
  Olutimilehin Olushuyi is a lawyer, new to accessibility. We talked about
  his battle with JavaScript, international standards, and the importance
  of reading a website's contents.
description: >
  One of a series of interviews with people from the web development
  community who work in web accessibility. This time we spoke with
  Olutimilehin Olushuyi.
date: 2022-11-09
tags:
  - blog
  - accessibility
  - community
---

_This post highlights a community expert, as a part of [Learn Accessibility!](/learn/accessibility/)_

**Alexandra White**: How'd you get started with web accessibility?

<figure data-float="right">
{% Img
  src="image/VbsHyyQopiec0718rMq2kTE1hke2/gAeaexQOr9TO1FaNvpqb.jpeg", alt="Olutimilehin Olushuyi's headshot.",
  width="350", height="334"
%}
</figure>

**Olutimilehin Olushuyi (Shuyi)**: Okay, so, it's a funny story. I'm a lawyer.
I realized in my final year of school, I didn't want to practice law for the
rest of my life. So, I tried to drop out of school, but my dean and "school
mother," [Professor Ayodele Atsenuwa](https://www.iclrs.org/ayodele-atsenuwa/),
said, "Let's talk about this. You're in your final year&mdash;just finish it." 

Ultimately, I'm happy she said that, and I'm happy I finished, because it's
been helping me in my accessibility work. Professor Atsenuwa asked me what I
wanted to do instead, and I had no idea.

I started to look up new career opportunities, and got in touch with some
people who wanted to build a startup and needed a lawyer. That opportunity
wasn't the right fit, but that was the first time I knew people wrote code for
all of the products we use. I thought, "I can pick this up." I started to teach
myself HTML and CSS. Then, I got to JavaScript and … [laughs] JavaScript did
JavaScript things, so I went back to focus on my front-end semantic languages.

I came across the work of [Andy Bell](https://piccalil.li/) and
[Heydon Pickering](https://heydonworks.com/). I purchased
[Every Layout](https://every-layout.dev/), and it changed my life. Andy kept
mentioning accessibility, but I didn't know what that meant in this context. I
realized I may be able to work in web development without needing to know how
to write JavaScript! 

I reached out to Heydon and he was very receptive, very responsive. It seems
everyone in the accessibility field is that way, and I'm grateful for that. 

**Alexandra**: I'd definitely agree, everyone I've spoken with has been so kind
and so helpful.

**Shuyi**: Absolutely. Currently, I do a lot more work in advocacy. I'm based
in Nigeria, a country where web accessibility is not mandated by law. The
Discrimination Against Persons with Disabilities Act passed sometime in 2018.
But there's no web accessibility law, only law about physical accessibility.
It's like the USA's Americans with Disabilities Act (ADA). Our law is poorly
structured, but better than nothing. 

I realized if I'm going to have any chance to make a difference and become an
accessibility focused developer, first I have to make the ecosystem aware of
accessibility needs. I started tweeting about accessibility advocacy. I talked
to companies and brands, whose buy-in is needed to get accessibility to work.

**Alexandra**: I bet your legal background is incredibly useful in working with
accessibility. You can actually read the new legislation and understand it in a
way that the average person won't. That includes an average developer.

**Shuyi**: I think one of the biggest gifts from my legal background is that I
can sit through unending pages of background materials, really lengthy
documents, without getting tired. I just fold my legs, put my laptop up, and
start to read. And read. And read. It's got advantages,

**Alexandra**: I mean … I'm jealous, that's a great skill to have. Do you think
you'd ever work with the government to get a digital accessibility law passed?

**Shuyi**: I'll be honest, I don't think so. Engaging with the government is a
different ball game. It takes too long to get our government to do something,
especially as an individual. That kind of work is better for NGOs and other
organizations with staffing and resources to bring about change.

The physical law took so much time to pass, and accessibility needs moved far
beyond what ended up in the law years ago. It's like the first draft was passed
even though the world has changed.

Ultimately, we're happy there's something to rely on, no matter how outdated it
ended up being. There is a law to enforce.

## Create accessible layouts

**Alexandra**: I read your article,  [`<article>` vs. `<section>`: How To Choose The Right One](https://www.smashingmagazine.com/2022/07/article-section-elements-accessibility/)
in Smashing Magazine and the [Twitter thread](https://twitter.com/ShuyiOlutimi/status/1455244970345082884?s=20&t=msdrhIBdSXGiEkc2pg0mOA)
that inspired it. What would you say is one big takeaway, what's the one thing
you want from web developers?

**Shuyi**: Developers must read the content before they begin building layouts. 

Originally, for my site design, I had just counted the number of paragraphs and
put them in sections and articles, without much thought. But,
[someone drew my attention to the misuse of sections](https://twitter.com/gracesnow/status/1455297078297518085)&mdash;it
was the first time I thought about it. Reading the content is one thing you can
do to make a better product.

**Alexandra**: When I was a developer, I often had freelance clients say, "Oh,
just build something for us and we'll fill the content in later." And sure,
there are some pages that have automatic context, like a contact page. But
knowing how many pages to build, and what kind of custom support was needed,
that could only be answered when I got the content.

**Shuyi**: Before knowing what I know, my best client would give me general
design ideas, and I'd built out a site with a bunch of lorem ipsum. I'll figure
all that stuff out. But, when you realize how much the content infrastructure
affects users on the web, you realize just how much of the standard process for
building things on the web is actually flawed. You must be intentional when you
build things.

So much accessibility infrastructure work doesn't get attention at all, and it
breaks my heart.

{% Aside 'codelab' %}
Take the Learn Accessibility module on
[Content structure](/learn/accessibility/structure) to read about semantic HTML,
landmarks, data tables, and more.
{% endAside %}

**Alexandra**: How did you do your research to make sure the advice you gave in
the article was correct?

**Shuyi**: First, I separated the sources of information&mdash;that's something
you do in law, separating primary and secondary sources. The primary sources
are the actual law (like the ADA and Nigeria's laws) and the secondary sources
are what experts interpret from the law.

I decided to refer only to the primary sources: the HTML, WCAG, and WAI-ARIA
specs. I read other people's works, a lot of good work. But, at the end of the
day, the opinions were so divergent, I decided I could only take them as useful
context but not rely on them as having the right answers.

## Build an accessible community

**Alexandra**: You mentioned trying to shape your Twitter feed into a place for
accessibility. Have you had many other conversations on Twitter since the
Smashing Magazine article's publication about what you learned?

**Shuyi**: For the first couple of days, I couldn't make good sense of Twitter.
So many people followed me, like 200+ people. At first I was excited, but then
I was scared. Like, I'm just starting out, don't follow me for a bunch of sage
wisdom. I was added to a lot of Twitter lists.

But like, I'm a person. I tweet about a lot of vague, non-accessibility,
non-web developer stuff. I don't want to let people down. Don't follow me just
because of accessibility! I'll feel like I'll let you down.

**Alexandra**: [laughs] I mean, I think a lot of people think that. I certainly
do about my Twitter persona.

**Shuyi**: Most responses to the article itself were positive. I got one
response to the article which was a bit controversial. [Vitaly](https://www.smashingmagazine.com/author/vitaly-friedman/) was my
editor, and he reached out directly to share
[the comment](https://www.smashingmagazine.com/2022/07/article-section-elements-accessibility/#1659357715965608590)
and asked me to investigate. Turns out, the person was referencing the MDN docs
which said that all [articles should have a heading element](https://developer.mozilla.org/docs/Web/HTML/Element/article#usage_notes).
I recommended that the section should have a heading element based on the specs.

The MDN docs recommend including the header but don't really explain what the
benefit is.

The spec changes less frequently than user needs, of course, so as long as you
can back up your decision to change the way you build something, it's probably
okay.

So, let me give an example. Let's say you're building a card component called
"Prices," with three elements in it. Hayden Pickering would suggest putting
each card into a list element. That way, when someone using assistive
technology (AT) gets to that section, it's announced to them that there are
three items in the price list. You can style the list so that there are no
bullet points, make it look however you want, but it helps AT users get the
useful information first. If you wrapped each item in a div, you'd just be
focused on the visual aspects, which doesn't help visually impaired users.
Think of people before design. 

I took that idea, and transposed it for a blog page. The blog posts are actually within a list element. That way, on entry to the page, the user is alerted that they are at one of some number of posts on the page.

So, I stood by my recommendations in the article, and I will until I understand
why MDN makes the recommendation.

**Alexandra**: Since the MDN docs are open source, will you suggest changes and
make updates there?

**Shuyi**: I'll be honest, I haven't yet made any open source
contributions. But, this is the kind of work I would like to be doing,
certainly more than working with the government.

## Spec versus implementation

**Alexandra**: It sounds like one big takeaway is that sometimes the spec says
one thing, but implementation and other external docs may suggest doing
something different. How does someone decide whose advice to follow?

**Shuyi**: I think about this a lot. I'm not sure I have the required
experience to answer that question. We're always trying to future-proof. It's
good to make continuous enhancements as the web changes. That way, when the
spec is updated, you don't need to retrofit your site. What are the chances
that you make a choice and three years from now the spec changes.

Every choice we make now is our best guess of what we think the future of the
web will look like, what direction we think the spec writers will go.

**Alexandra**: The web is constantly changing, one person can't have all of the
answers! Did the specs go through changes while you were writing?

**Shuyi**: I started writing my article before the
[document outline model](https://developer.mozilla.org/docs/Web/HTML/Element/Heading_Elements#multiple_h1_elements_on_one_page)
was removed from the spec. This model suggested that heading levels should be
automatically calculated based on how deep the nesting was. But it was never
really implemented and that created a lot of issues for developers. The advice
to developers was to manually fix their headings.

If the article had been published before the spec change, I probably would have
gone back and made that edit&mdash;it is in Smashing Magazine after all. But if
it had lived on my personal blog, would I have? Probably not. And that's just
talking about updating an article, not updating an entire website that's built
based on a changing spec.

Do we expect developers to immediately change their websites when the spec
changes? Of course not. They make calculations as to what's best when they're
building their sites and live with those choices. The specs will change, the
specs may not have the answer.

## Accessibility as a career

**Alexandra**: How much of your time do you spend thinking about global
accessibility standards? Standards and laws are different around the world. I'm
sure you've read a lot of them, and I'm sure some laws tell you to do the
opposite things. What would you do in those cases?

**Shuyi**: I thought about launching a business for freelance accessibility
work. I went into a global web accessibility chat channel and asked for tips on
how to get started. [Adrian Roselli](https://adrianroselli.com/) reached out
and said, "Your clients will be relying on you to keep them compliant with laws
which could have major consequences. Before you offer your services, know what
region you have expertise in. Know what laws you're familiar with so that,
while you're making a living for yourself, you don't leave clients with huge
liabilities. They trust you to know the law."

Of course, so many businesses are seeking accessibility help because they are
legally required, and not just because it's the right thing. Capitalism is the
reason accessibility is being implemented. At the end of the day, it doesn't
matter why it happened, it matters that the product is accessible.

{% Aside 'codelab' %}
Learn more about the [business impact of digital accessibility](/learn/accessibility/why/#business-impact).
{% endAside %}

I put a pause on freelancing until I have full confidence that I can help
clients with the laws of their region. Standardization is critical, the efforts
and impact of WCAG cannot be overstated. Having a central framework of how the
web should work makes it easier for governments to rely on the same standard.
But of course, not every government will accept those standards.

**Alexandra**: You've gotten a lot of great advice from great people in your
journey into accessibility. Is there any other advice you wish you'd gotten
before you decided to pursue this as a career?

**Shuyi**: While it wouldn't have changed my career path, it would have been
nice to know that as noble as accessibility work is, it's greatly affected by
capitalism. 

**Alexandra**: [laughs] Oh yes.

**Shuyi**: And I'm a junior. I have a year of experience in accessibility.
Especially if you're based in Africa, like I am, there's a limited availability
of positions in accessibility. Companies are hiring managers, one person to
meet whatever legal requirements are needed. But I want to work on a team,
where I can learn and build skills.

I was so excited to get to work without learning JavaScript&mdash;that I could
just learn the rules and help my team apply them. But the developer positions
at agencies require that I have JavaScript experience. I moved to a new city
and joined a JavaScript bootcamp so I can meet those requirements. For anyone
else on their accessibility journey, know that you must focus on building your
development skills first.

I'm not going to lie, I still don't like JavaScript. 

## Do one thing: add keyboard focus

**Alexandra**: [laughs] Is JavaScript the reason I'm now a tech writer instead of a developer? Yes. Yes, it is. I hate it so much. I wish you the best of luck in your boot camp.

What's one thing you want developers to do to make their site accessible?

**Shuyi**: Keyboard focus. I am begging from the bottom of my heart. My
trackpad currently doesn't work, so when I'm on the go, I rely on my keyboard
to navigate the web, and almost every website is horrible. Keyboard focus
doesn't just benefit disabled people.

Building accessible platforms benefits everyone.

{% Aside 'codelab' %}
Take the Learn Accessibility module on
[Keyboard focus](/learn/accessibility/focus/) to discover how to
ensure all users can navigate your content.
{% endAside %}

<hr />

Keep up with Shuyi's work on Twitter
[@shuyiolutimi](https://twitter.com/shuyiolutimi).
