---
layout: post
title: 'Community highlight: Albert Kim'
authors: 
  - alexandrawhite
hero: image/VbsHyyQopiec0718rMq2kTE1hke2/8nibxhPpYh7CcJmZubSa.png
alt: 'Learn Accessibility! Community highlight.'
thumbnail: image/VbsHyyQopiec0718rMq2kTE1hke2/8nibxhPpYh7CcJmZubSa.png
subhead: >
  Albert Kim is a multi-faceted accessibility expert, leading the
  conversation around mental health and digital accessibility.
description: >
  Albert Kim is a multi-faceted accessibility expert, leading the
  conversation around mental health and digital accessibility.
date: 2022-11-17
tags:
  - blog
  - accessibility
  - community
---

_This post highlights a community expert, as a part of [Learn Accessibility!](/learn/accessibility/)_

**Alexandra White**: How would you introduce yourself? You do so much accessibility work.

**Albert Kim**: I'm a digital accessibility subject matter expert (SME), a UX
design consultant, and a public speaker and coach, raising mental health
awareness in the tech community.

<figure data-float="right">
  {% Img
    src="image/VbsHyyQopiec0718rMq2kTE1hke2/oXT7rUXWYTEXaDfIabUf.jpg",
    alt="Albert Kim is an accessibility SME.", width="350", height="314"
  %}
</figure>

I founded [Accessibility NextGen](https://twitter.com/a11ynextgen), a community
for people interested in learning more about accessibility. I'm a
[Disability:IN NextGen Leader](https://disabilityin.org/what-we-do/nextgen-leaders-initiatives/).
And currently, I'm a W3C invited expert for the
[Cognitive and Learning Disabilities Task Force](https://www.w3.org/WAI/GL/task-forces/coga/)
and Mental Health Sub-Group. Lately, I've been researching how to include
people with OCD, ADHD, dyslexia, and PTSD into the product development
process.

Offline, I'm a DEI community leader, blogger, huge foodie, photographer, and I
love traveling—I travel a lot. I'm the first generation in my family to live
abroad, the first generation to get any formal education. I was raised by a
single mother in a low-income household. I'm a military veteran. 

I identify myself as someone who can empathize with a lot of different
struggles and life stories.

**Alexandra**: Did you always think you'd be someone who would have a career or
work in accessibility?

**Albert**: I always wanted my profession to be not just a job, but one with
social impact. I've switched careers several times. In college, I tried
different majors. I've founded startups, I was a business development manager,
I worked in telecommunications in the military. I was an interpreter. I've had
many different jobs.

It's important to mention all of these different experiences, as all of the
dots began to connect in their own way. I eventually got into digital
accessibility because of my personal experience as someone with a disability,
but also with a love for digital products. I really, really love a good
product. Useful, functional products.

We often use the phrase "[assistive technology](/learn/accessibility/glossary/#at),"
but all technologies are assistive. I'm passionate about digital products that
help improve my life, that make my life easier. I want to connect consumers
with the producers of digital products, and digital accessibility is
fundamental to that connection.

**Alexandra**: Can you expand more on how you create opportunities for direct
communication between users and product creators?

**Albert**: Often, when developers build digital products, they don't make full
use of their own product. They aren't aware of how useful their product
is for users, especially those with disabilities. That means that they're not
thinking about those use cases in the design process. Because of this, they
often miss an opportunity to discover disabled users who could become loyal
customers.

Designers and developers may or may not find out later that what they built is
useful to disabled users.

Connecting product owners and developers to their users with disabilities
early in the product development process can lead to full realization of
a product's potential. This is in addition to products designed with accessibility as an intentional feature.

As a metaphor, I love sharing good food with my loved ones. The joy is doubled
when I can share it. Just like that, I want to share really good products with
my friends, but I cannot always share them if they're not accessible. A blog
post alone, without a screen reader or other interventions, is not accessible
to my blind friend. If digital product makers hear these stories from users,
then hopefully they'll make accessible design choices so the users can fully
utilize their products.

## Build for "invisible" disabilities

**Alexandra**: I appreciate that you mentioned your blind friend specifically,
because often the first thing that comes to mind when developers and designers
_do_ think about disability are the "obvious" ones: visible and often permanent
disabilities. But there are [so many people impacted by accessible
design](/learn/accessibility/why/#additional-beneficiaries-of-accessibility),
such as those with temporary and invisible disabilities, like psychological
disabilities.

You're an invited expert to the W3C group, ​​the
[Cognitive and Learning Disabilities Task Force](https://www.w3.org/WAI/GL/task-forces/coga/)
and Mental Health subgroup. What is COGA?

**Albert**: The COGA task force is a joint commitment of the Accessible
Platform Architecture (APA) Working Group and the Web Content Accessibility
Guidelines (WCAG) Working Group. COGA assists these other groups in creating
guidance documents, as well as updates to existing W3C accessibility
guidelines. For example, we further developed proposed success criteria for WCAG 2.1.

We've built a repository of [user research](https://w3c.github.io/coga/user-research/)
to serve as supplemental guidance and have published
[issue papers](https://w3c.github.io/coga/issue-papers/).

Often, companies and developers look at WCAG guidelines as their standard for
web accessibility. But, there's supplemental guidance in the form of issue
papers. COGA has written some of these papers on different use cases to help
describe cognitive disabilities and scenarios where persons with atypical
profiles use technology successfully and unsuccessfully. We help these working
groups think about cognitive disabilities and learning disabilities.

**Alexandra**: Have you been with COGA from the start?

**Albert**: I joined a few years after the group was developed; but after I
joined, I strongly advocated for a mental health subgroup. COGA's focus was
primarily on cognitive and learning disabilities, but I wanted to start a
conversation about mental health.

I happened to know someone in that community who reached out on Twitter.
I got in through that connections, and I'm very passionate about bringing
invisible disabilities into web accessibility spaces.

## Participate in COGA and other W3C initiatives

**Alexandra**: Can anyone participate in such a group, and do people attend
regularly?

**Albert**: It's an open group! [Anyone can join](https://www.w3.org/WAI/GL/task-forces/coga/#participation),
as participants of either the APA Working Group or the WCAG Working Group. If
your company sponsors the W3C, you can join, or as an independent invited
expert. I'm an independent invited expert.

**Alexandra**: For most of my career, I didn't know that. I didn't realize how
much power an individual could have in influencing and even creating standards
that make up the web.

**Albert**: It's definitely a big time commitment and a lot of
responsibilities. For some, that may not be feasible.

The easiest way to participate is to join the
[COGA Accessibility Community Group](https://www.w3.org/community/coga-community/).
The community groups are more flexible and don't have as much responsibility or
commitments. This group supplies user needs and feedback to the COGA Task Force.

**Alexandra**: Here's where I confess my own stakes in this work, in your
subgroup. I suffer from anxiety and depression, and have for most of my life.
There are times I'm overwhelmed by certain sites and apps, even those which are
meant to help us be "productive," as some tasks have long checklist steps
before you can move to the next task. Tools which are helpful on my best days
can be overwhelming the next day.

In your [Accessibility Rules interview](https://a11yrules.com/podcast/albert-kim-talks-about-ocd-ptsd-and-web-accessibility/),
you mentioned the ways in which endless scroll can be traumatic, and how that
affects you as a person with OCD and PTSD. Is there guidance out there or sites
that are doing a good job of giving people a way to opt-out of an experience
that may be triggering.

**Albert**: There is a [COGA issue paper](https://www.w3.org/TR/coga-usable/#make-the-relationship-clear-between-controls-and-the-content-they-affect-pattern),
that has supplemental guidance. As far as websites or
resources acting as a good example… that might be hard to find! Addressing
mental health in web development is still very new. But I do have a lot of
advice and specific best practices that I can recommend as a user with
disabilities and as an accessibility SME.

{% Aside %}

The [COGA issue paper](https://www.w3.org/TR/coga-usable/#make-the-relationship-clear-between-controls-and-the-content-they-affect-pattern)
doesn't directly consult on endless scroll. This advice comes from both
Albert's experience as a neurodivergent user and common best practices.
Preventing endless scroll is a widely accepted and understood as an
accessibility best practice.

{% endAside %}

First thing, follow the WCAG guidelines, though most of them were written prior
to the mental health subgroup existing, so much of that guidance is helpful
beyond those with physical disabilities. It's helpful for users with invisible
disabilities and mental health disabilities. Following this, that has to be the
beginning. If websites were following these guidelines and did a really good
job, even if they didn't think about mental health at all, we probably wouldn't
experience many of these problems.

One of the most important design choices that would be helpful is clear,
semantic structure. Clear headings can be very helpful for users with OCD,
ADHD, or dyslexia. Even for me, and my anxiety as well. All of these illnesses
share some pain points, they're interconnected. 

## Stop creating bad user experiences

**Alexandra**: Okay, what about the opposite? What are people building that is
against WCAG recommendations that is causing problems for those with mental
health issues?

**Albert**: So many things:

* Complex navigation and page layouts that are difficult to navigate and use.
* Multi-stage forms that have a lot of imposed requirements, rather than
  communicating with users why something is important or needed.
* Long passages of complex text with a lot of jargon or metaphors that are
  difficult to understand, which require additional context.
* Flickering content or background images that are moving or blinking.
  Notifications that you can't turn off easily.
* Timeouts on complex activities, especially without options to save, such as
  when you're filling out a form and you're given a warning or a timeout after
  30 seconds.
* Search on websites that doesn't work well. This may mean there's a lack of
  filters, and that leads to an endless set of results.
* Unexpected behavior, like when you click a button and the page jumps back to
  the top so you have to figure out where you were and scroll back down.
* Hidden actions, like when a cookie popup requires multiple steps in really
  small print to decline the cookies. Or deliberately making subscriptions that
  are really hard to cancel.

These aren't just accessibility issues, these are usability issues.

**Alexandra**: Good product design is accessible design.

**Albert**:  There are so many examples. Make a good product and users will
come back. These are just some examples.

## Include content warnings

**Alexandra**: Something often politicized, at least in the United States, is
the idea of content warnings (colloquially known as "trigger warnings").

These warnings may be related to a design choice—flashing images may cause seizures. Those are less controversial, and fairly commonplace. However, content
warnings for certain subjects is also critical for many.

**Albert**: If your content has something sensitive, such as violence or
mentions of sexual assault, having warnings can be very helpful for users with
PTSD, depression, and anxiety, especially as it may stem from personal
experience of traumatic events. Allow for customization and personalization
that is obvious, so people can choose what information they are ready to read,
see, or hear.

The core meaning of the web is to relay information. Rather than imposing our
information, we should be communicating it. We should think about how others
will perceive what we have to share. I may write something one way, but it may
be interpreted by someone else in a different way. Clear structure helps to
avoid some of these miscommunications.

Summaries and tables of content are also very helpful in allowing a user to
prepare themselves for what they'll be learning.

{% Aside %}

If you include a content warning in a video, it's critical to let this warning
play for long enough that people can read the message, especially in contexts
where the video may not be paused.

{% endAside %}

**Alexandra**: I'm personally grateful for these content trigger warnings, so I
can decide if I'm in a place where I feel comfortable reading or seeing content
which may lead to an emotional reaction. For those who are worried that there
may be pushback on including trigger warnings in their content, do you have any
advice?

**Albert**: We must think of it as a public health issue, not a political
issue. Trigger warnings are not about censorship, at all. It's about giving
users freedom to choose. When we don't provide the option, then we don't give
users freedom to protect themselves from something that may cause harm to their
mental health.

We shouldn't arbitrarily impose or force information on users. The most common
reaction for people with PTSD who encounter trigger content is to leave and
never come back. You lose those people. It's a health issue.

{% Aside %}

If you get pushback on adding space for trigger warnings, you could argue it's
a business issue. When you lose those users forever, you lose that revenue or
potential revenue. 

Learn more about the
[business impact of accessibility](/learn/accessibility/why/#business-impact).

{% endAside %}

**Albert**: There's some similarity between a trigger warning and a parental
control. We don't have any political concerns about letting parents choose what
is acceptable to be seen by their children. It's very conventionally
understood. This is exactly the same. People deserve to have control for
themselves.

**Alexandra**: Seems reasonable to me!

## Do one more thing: communicate clearly

**Alexandra**: If you asked developers to change one thing about the way they
design and build websites to make them more accessible, what would you ask for?

**Albert**: Don't forget that the fundamental purpose of a website is to
clearly communicate information to the user. To do this, you must think about
what information you want to share with your users, and more importantly, how
to frame that information so the content and your intentions are understood.

{% Aside 'codelab' %}
Take the Learn Accessibility module on
[Content structure](/learn/accessibility/structure) to read about semantic HTML,
landmarks, data tables, and more.
{% endAside %}

You can succeed by building each page with semantic HTML, use a clear
structure and layout of content. Clear structure and layouts help you
communicate better with your users, and are more scalable, usable, and
accessible. Ensure labels are consistent and instructions are provided
correctly. This helps users more easily find the information they seek and
better understand the relationships between different parts of the content.

This advice touches upon three WCAG success criteria:

* [2.4.6. Headings and Labels](https://www.w3.org/TR/UNDERSTANDING-WCAG20/navigation-mechanisms-descriptive.html)
* [1.3.1. Info and Relationships](https://www.w3.org/TR/UNDERSTANDING-WCAG20/content-structure-separation-programmatic.html)
* [3.3.2. Labels or Instructions](https://www.w3.org/TR/UNDERSTANDING-WCAG20/minimize-error-cues.html)

Missing these success criteria is among the most common accessibility issues
found on websites. This affects people who use assistive technologies (such as
screen readers), but also neurodivergent people who may have cognitive and/or
learning disabilities or mental health conditions.

<hr />

Keep up with Albert's work on Twitter as
[@djkalbert](https://twitter.com/djkalbert). Check out
[Accessibility NextGen](https://www.meetup.com/a11ynextgen/).
