---
layout: post
title: Carnival Cruise Line
date: 2016-11-09
updated: 2016-11-09
tags:
  - blog
  - case-study

---

<figure>
{% Img src="image/T4FyVKpzu4WKF1kBNvXepbi08t52/P3Ur4zVpuoycct8dKsRy.png", alt="Carnival detail", width="800", height="450" %}
</figure>

### Summary

**Carnival Cruise Line provides personalized, engaging communication service for
its customers with push notifications.**

### Results

- 24% opt-in to push notifications (16% on desktop, 32% on mobile)
- 42% open rate

[Download PDF Case study](https://storage.googleapis.com/web-dev-uploads/file/T4FyVKpzu4WKF1kBNvXepbi08t52/V4APAsCurLCOS7miv9C4.pdf)

## About Carnival Cruise Line

Carnival Cruise Line, one of the world’s largest leisure-travel companies,
wanted to enhance how it re-engaged its customers. The objective was to send
timely, customized information that did not have to compete for attention in a
customer’s inbox, worked on all devices and was easy to act on. Working with
Mobify, Carnival implemented push notifications for mobile web users on Android
and for desktop users on Chrome. The new strategy delivered a 42% engagement
rate from customers who receive notifications.

## Challenge

Until late 2016, Carnival primarily depended on targeted emails to re-engage
customers who had placed a hold on cruise bookings. Internal research showed
there was an opportunity to motivate more users to return to the site to
complete their bookings. With a significant amount of its web traffic on mobile
browsers, Carnival looked to innovative technologies such as push notifications
on the mobile web as well as desktop to re-engage customers who had created
their holds and wanted to receive highly relevant communication beyond the
standard email.

## Solution

Carnival and Mobify implemented push notifications, which let customers receive
realtime updates on their “courtesy holds” including when the free hold on their
vacation was set to expire. The information was critical in driving users back
to the site to complete payment. On mobile, the notifications look the same as
those from native apps, and arrive even when the browser isn’t running. The new
push notifications resulted in a 16 percent opt-in rate on desktop and 32
percent on mobile.

Carnival can now reach customers on multiple types of devices without having to
wait for the user to check their email and miss the opportunity to book their
vacation before the hold expires. The company is already seeing a high opt-in
rate, which is a valuable difference to its bottom line.

>We see an improvement of our conversion rate supported by this new, innovative
way of engaging our customers across different devices,’ says Steven Frier,
Carnival’s director of e-commerce. ‘There is a direct 42 percent click through
rate from push notifications. Having another channel to reach our users is a
game changer.
