---
layout: post
title: BookMyShow’s new Progressive Web App drives an 80% increase in conversions
description: |
  BookMyShow is India’s largest ticketing firm, with 50+ million monthly visitors. They developed an improved version of their mobile website using a Progressive Web App (PWA), optimizing speed and removing data constraints, which resulted in an 80+% increase in conversions.
date: 2017-10-18
updated: 2017-10-18
tags:
  - blog # blog is a required tag for the article to show up in the blog.
  - case-study
---

<figure>
{% Video src="video/T4FyVKpzu4WKF1kBNvXepbi08t52/Lqz8rWt3D2px2obyxvTa.mp4", autoplay="true", loop="true", muted="true" %}
</figure>

[BookMyShow](https://in.bookmyshow.com/) is India’s largest ticketing firm,
with 50+ million monthly visitors. They developed an improved version of their
mobile website using a Progressive Web App (PWA), delivering an **80+% increase
in conversions, which means more users purchasing tickets.**

{% Blockquote 'Sahil Tewari, Assistant General Manager, Mobile & Web '%}
Since launching our PWA, we’ve seen an exponential increase in mobile
conversion rates. The PWA helped us connect with more people on mobile — and
it's mobile users who make up the majority of our overall audience.
{% endBlockquote %}

- BookMyShow's PWA drove an 80%+ increase in their conversion rates.
- The size of the PWA is 54x smaller than the Android app and 180x smaller
  than the iOS app.
- The PWA takes less than 2.94 seconds to load and enables checkout within
  30 seconds.

## Challenges

BookMyShow has a growing mobile audience. Over 85% of transactions happen
on mobile, and the company’s mobile web traffic recently overtook their desktop
web traffic. Even with this growth in traffic, the company still encountered
high bounce rates because their mobile website's load speed and user experience
weren’t optimal.

Their native app also posed problems as it required heavy data and memory usage
to be effective. “People were using the native app and were happy with it, but
their main concerns were the data usage and the memory it consumes,” says Anish
Tripathi, Vice President of Design. “And if they uninstalled the app and tried
using the mobile browser, it didn’t work the same way.”

## Solution

Knowing that speed and efficiency are key to a good ticket-buying experience,
BookMyShow launched a PWA to deliver the best mobile web experience possible
to the majority of their users. A PWA would provide a smooth, seamless movie-
booking experience that would optimize speed and remove data constraints for
existing customers, without sacrificing the user experience.

The shift to a PWA also gave BookMyShow the opportunity to simultaneously
migrate away from their PHP backend stack, which involved redoing some core
development work. They adopted cutting-edge solutions and built a truly
powerful, technically-advanced web app that provides users with fast,
reliable, and engaging experiences just like the native app.

The PWA is optimized for speed. The goal for the app—which took only **10
months** to build—was created to enable checkout within **30 seconds**. They
were also excited to use the
“[**add to home screen**](/customize-install/)” feature
to provide a native-app like experience. Their PWA application is only about
440KB — **54 times smaller** than the Android app and **180 times smaller**
than the iOS app. BookMyShow also took advantage of service workers to deliver
reliable performance on slow or unreliable networks. Data consumption is also
substantially lower, thanks to optimization. When a user asks for a particular
page, only assets required for that page are loaded, conserving data. On 2G
networks, the initial load time is just **4 seconds**. Even for personalized
movie suggestions, the PWA takes **less than 2.94 seconds** in subsequent
loads. All of these changes resulted in an **80+% increase in conversion**
rates, a huge difference in BookMyShow’s bottom line.
